<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Firmware2PatchStatusInfo StructType
 * @subpackage Structs
 */
class Firmware2PatchStatusInfo extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The StatusTimeUTC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StatusTimeUTC;
    /**
     * The Imei
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Imei;
    /**
     * The SerialNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerialNumber;
    /**
     * The FirmwareVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirmwareVersion;
    /**
     * The BuildNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BuildNumber;
    /**
     * Constructor method for Firmware2PatchStatusInfo
     * @uses Firmware2PatchStatusInfo::setStatus()
     * @uses Firmware2PatchStatusInfo::setStatusTimeUTC()
     * @uses Firmware2PatchStatusInfo::setImei()
     * @uses Firmware2PatchStatusInfo::setSerialNumber()
     * @uses Firmware2PatchStatusInfo::setFirmwareVersion()
     * @uses Firmware2PatchStatusInfo::setBuildNumber()
     * @param string $status
     * @param string $statusTimeUTC
     * @param string $imei
     * @param string $serialNumber
     * @param string $firmwareVersion
     * @param string $buildNumber
     */
    public function __construct($status = null, $statusTimeUTC = null, $imei = null, $serialNumber = null, $firmwareVersion = null, $buildNumber = null)
    {
        $this
            ->setStatus($status)
            ->setStatusTimeUTC($statusTimeUTC)
            ->setImei($imei)
            ->setSerialNumber($serialNumber)
            ->setFirmwareVersion($firmwareVersion)
            ->setBuildNumber($buildNumber);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \CustomerManagement\EnumType\Firmware2PatchStatusEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\Firmware2PatchStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \CustomerManagement\StructType\Firmware2PatchStatusInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\Firmware2PatchStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\Firmware2PatchStatusEnum', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \CustomerManagement\EnumType\Firmware2PatchStatusEnum::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusTimeUTC value
     * @return string
     */
    public function getStatusTimeUTC()
    {
        return $this->StatusTimeUTC;
    }
    /**
     * Set StatusTimeUTC value
     * @param string $statusTimeUTC
     * @return \CustomerManagement\StructType\Firmware2PatchStatusInfo
     */
    public function setStatusTimeUTC($statusTimeUTC = null)
    {
        // validation for constraint: string
        if (!is_null($statusTimeUTC) && !is_string($statusTimeUTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusTimeUTC, true), gettype($statusTimeUTC)), __LINE__);
        }
        $this->StatusTimeUTC = $statusTimeUTC;
        return $this;
    }
    /**
     * Get Imei value
     * @return string|null
     */
    public function getImei()
    {
        return $this->Imei;
    }
    /**
     * Set Imei value
     * @param string $imei
     * @return \CustomerManagement\StructType\Firmware2PatchStatusInfo
     */
    public function setImei($imei = null)
    {
        // validation for constraint: string
        if (!is_null($imei) && !is_string($imei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imei, true), gettype($imei)), __LINE__);
        }
        $this->Imei = $imei;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return \CustomerManagement\StructType\Firmware2PatchStatusInfo
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialNumber, true), gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get FirmwareVersion value
     * @return string|null
     */
    public function getFirmwareVersion()
    {
        return $this->FirmwareVersion;
    }
    /**
     * Set FirmwareVersion value
     * @param string $firmwareVersion
     * @return \CustomerManagement\StructType\Firmware2PatchStatusInfo
     */
    public function setFirmwareVersion($firmwareVersion = null)
    {
        // validation for constraint: string
        if (!is_null($firmwareVersion) && !is_string($firmwareVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firmwareVersion, true), gettype($firmwareVersion)), __LINE__);
        }
        $this->FirmwareVersion = $firmwareVersion;
        return $this;
    }
    /**
     * Get BuildNumber value
     * @return string|null
     */
    public function getBuildNumber()
    {
        return $this->BuildNumber;
    }
    /**
     * Set BuildNumber value
     * @param string $buildNumber
     * @return \CustomerManagement\StructType\Firmware2PatchStatusInfo
     */
    public function setBuildNumber($buildNumber = null)
    {
        // validation for constraint: string
        if (!is_null($buildNumber) && !is_string($buildNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildNumber, true), gettype($buildNumber)), __LINE__);
        }
        $this->BuildNumber = $buildNumber;
        return $this;
    }
}
