<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteImageSensorInput StructType
 * @subpackage Structs
 */
class DeleteImageSensorInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The ImageSensorMacAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImageSensorMacAddress;
    /**
     * Constructor method for DeleteImageSensorInput
     * @uses DeleteImageSensorInput::setCustomerId()
     * @uses DeleteImageSensorInput::setImageSensorMacAddress()
     * @param int $customerId
     * @param string $imageSensorMacAddress
     */
    public function __construct($customerId = null, $imageSensorMacAddress = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setImageSensorMacAddress($imageSensorMacAddress);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\DeleteImageSensorInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get ImageSensorMacAddress value
     * @return string|null
     */
    public function getImageSensorMacAddress()
    {
        return $this->ImageSensorMacAddress;
    }
    /**
     * Set ImageSensorMacAddress value
     * @param string $imageSensorMacAddress
     * @return \CustomerManagement\StructType\DeleteImageSensorInput
     */
    public function setImageSensorMacAddress($imageSensorMacAddress = null)
    {
        // validation for constraint: string
        if (!is_null($imageSensorMacAddress) && !is_string($imageSensorMacAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageSensorMacAddress, true), gettype($imageSensorMacAddress)), __LINE__);
        }
        $this->ImageSensorMacAddress = $imageSensorMacAddress;
        return $this;
    }
}
