<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZWaveRoutingTableInfo StructType
 * @subpackage Structs
 */
class ZWaveRoutingTableInfo extends AbstractStructBase
{
    /**
     * The LocalNetworkId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocalNetworkId;
    /**
     * The Neighbors
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfNeighbor
     */
    public $Neighbors;
    /**
     * Constructor method for ZWaveRoutingTableInfo
     * @uses ZWaveRoutingTableInfo::setLocalNetworkId()
     * @uses ZWaveRoutingTableInfo::setNeighbors()
     * @param string $localNetworkId
     * @param \CustomerManagement\ArrayType\ArrayOfNeighbor $neighbors
     */
    public function __construct($localNetworkId = null, \CustomerManagement\ArrayType\ArrayOfNeighbor $neighbors = null)
    {
        $this
            ->setLocalNetworkId($localNetworkId)
            ->setNeighbors($neighbors);
    }
    /**
     * Get LocalNetworkId value
     * @return string|null
     */
    public function getLocalNetworkId()
    {
        return $this->LocalNetworkId;
    }
    /**
     * Set LocalNetworkId value
     * @param string $localNetworkId
     * @return \CustomerManagement\StructType\ZWaveRoutingTableInfo
     */
    public function setLocalNetworkId($localNetworkId = null)
    {
        // validation for constraint: string
        if (!is_null($localNetworkId) && !is_string($localNetworkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localNetworkId, true), gettype($localNetworkId)), __LINE__);
        }
        $this->LocalNetworkId = $localNetworkId;
        return $this;
    }
    /**
     * Get Neighbors value
     * @return \CustomerManagement\ArrayType\ArrayOfNeighbor|null
     */
    public function getNeighbors()
    {
        return $this->Neighbors;
    }
    /**
     * Set Neighbors value
     * @param \CustomerManagement\ArrayType\ArrayOfNeighbor $neighbors
     * @return \CustomerManagement\StructType\ZWaveRoutingTableInfo
     */
    public function setNeighbors(\CustomerManagement\ArrayType\ArrayOfNeighbor $neighbors = null)
    {
        $this->Neighbors = $neighbors;
        return $this;
    }
}
