<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCentralStationInfoInput StructType
 * @subpackage Structs
 */
class UpdateCentralStationInfoInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The ForwardingOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ForwardingOption;
    /**
     * The PhoneLinePresent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PhoneLinePresent;
    /**
     * The InitiateTwoWayVoiceForFireAndCoAlarms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $InitiateTwoWayVoiceForFireAndCoAlarms;
    /**
     * The DualPathSupervisionImmediate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $DualPathSupervisionImmediate;
    /**
     * The CSPhoneID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CSPhoneID;
    /**
     * The IncludeNonIntrusionDeviceTroubles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeNonIntrusionDeviceTroubles;
    /**
     * The EventGroupsToForward
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum
     */
    public $EventGroupsToForward;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The ReceiverNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverNumber;
    /**
     * Constructor method for UpdateCentralStationInfoInput
     * @uses UpdateCentralStationInfoInput::setCustomerId()
     * @uses UpdateCentralStationInfoInput::setForwardingOption()
     * @uses UpdateCentralStationInfoInput::setPhoneLinePresent()
     * @uses UpdateCentralStationInfoInput::setInitiateTwoWayVoiceForFireAndCoAlarms()
     * @uses UpdateCentralStationInfoInput::setDualPathSupervisionImmediate()
     * @uses UpdateCentralStationInfoInput::setCSPhoneID()
     * @uses UpdateCentralStationInfoInput::setIncludeNonIntrusionDeviceTroubles()
     * @uses UpdateCentralStationInfoInput::setEventGroupsToForward()
     * @uses UpdateCentralStationInfoInput::setAccountNumber()
     * @uses UpdateCentralStationInfoInput::setReceiverNumber()
     * @param int $customerId
     * @param string $forwardingOption
     * @param bool $phoneLinePresent
     * @param bool $initiateTwoWayVoiceForFireAndCoAlarms
     * @param bool $dualPathSupervisionImmediate
     * @param int $cSPhoneID
     * @param bool $includeNonIntrusionDeviceTroubles
     * @param \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward
     * @param string $accountNumber
     * @param string $receiverNumber
     */
    public function __construct($customerId = null, $forwardingOption = null, $phoneLinePresent = null, $initiateTwoWayVoiceForFireAndCoAlarms = null, $dualPathSupervisionImmediate = null, $cSPhoneID = null, $includeNonIntrusionDeviceTroubles = null, \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward = null, $accountNumber = null, $receiverNumber = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setForwardingOption($forwardingOption)
            ->setPhoneLinePresent($phoneLinePresent)
            ->setInitiateTwoWayVoiceForFireAndCoAlarms($initiateTwoWayVoiceForFireAndCoAlarms)
            ->setDualPathSupervisionImmediate($dualPathSupervisionImmediate)
            ->setCSPhoneID($cSPhoneID)
            ->setIncludeNonIntrusionDeviceTroubles($includeNonIntrusionDeviceTroubles)
            ->setEventGroupsToForward($eventGroupsToForward)
            ->setAccountNumber($accountNumber)
            ->setReceiverNumber($receiverNumber);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get ForwardingOption value
     * @return string
     */
    public function getForwardingOption()
    {
        return $this->ForwardingOption;
    }
    /**
     * Set ForwardingOption value
     * @uses \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $forwardingOption
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setForwardingOption($forwardingOption = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CentralStationForwardingOptionEnum::valueIsValid($forwardingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CentralStationForwardingOptionEnum', is_array($forwardingOption) ? implode(', ', $forwardingOption) : var_export($forwardingOption, true), implode(', ', \CustomerManagement\EnumType\CentralStationForwardingOptionEnum::getValidValues())), __LINE__);
        }
        $this->ForwardingOption = $forwardingOption;
        return $this;
    }
    /**
     * Get PhoneLinePresent value
     * @return bool
     */
    public function getPhoneLinePresent()
    {
        return $this->PhoneLinePresent;
    }
    /**
     * Set PhoneLinePresent value
     * @param bool $phoneLinePresent
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setPhoneLinePresent($phoneLinePresent = null)
    {
        // validation for constraint: boolean
        if (!is_null($phoneLinePresent) && !is_bool($phoneLinePresent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($phoneLinePresent, true), gettype($phoneLinePresent)), __LINE__);
        }
        $this->PhoneLinePresent = $phoneLinePresent;
        return $this;
    }
    /**
     * Get InitiateTwoWayVoiceForFireAndCoAlarms value
     * @return bool
     */
    public function getInitiateTwoWayVoiceForFireAndCoAlarms()
    {
        return $this->InitiateTwoWayVoiceForFireAndCoAlarms;
    }
    /**
     * Set InitiateTwoWayVoiceForFireAndCoAlarms value
     * @param bool $initiateTwoWayVoiceForFireAndCoAlarms
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setInitiateTwoWayVoiceForFireAndCoAlarms($initiateTwoWayVoiceForFireAndCoAlarms = null)
    {
        // validation for constraint: boolean
        if (!is_null($initiateTwoWayVoiceForFireAndCoAlarms) && !is_bool($initiateTwoWayVoiceForFireAndCoAlarms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($initiateTwoWayVoiceForFireAndCoAlarms, true), gettype($initiateTwoWayVoiceForFireAndCoAlarms)), __LINE__);
        }
        $this->InitiateTwoWayVoiceForFireAndCoAlarms = $initiateTwoWayVoiceForFireAndCoAlarms;
        return $this;
    }
    /**
     * Get DualPathSupervisionImmediate value
     * @return bool
     */
    public function getDualPathSupervisionImmediate()
    {
        return $this->DualPathSupervisionImmediate;
    }
    /**
     * Set DualPathSupervisionImmediate value
     * @param bool $dualPathSupervisionImmediate
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setDualPathSupervisionImmediate($dualPathSupervisionImmediate = null)
    {
        // validation for constraint: boolean
        if (!is_null($dualPathSupervisionImmediate) && !is_bool($dualPathSupervisionImmediate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dualPathSupervisionImmediate, true), gettype($dualPathSupervisionImmediate)), __LINE__);
        }
        $this->DualPathSupervisionImmediate = $dualPathSupervisionImmediate;
        return $this;
    }
    /**
     * Get CSPhoneID value
     * @return int
     */
    public function getCSPhoneID()
    {
        return $this->CSPhoneID;
    }
    /**
     * Set CSPhoneID value
     * @param int $cSPhoneID
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setCSPhoneID($cSPhoneID = null)
    {
        // validation for constraint: int
        if (!is_null($cSPhoneID) && !(is_int($cSPhoneID) || ctype_digit($cSPhoneID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cSPhoneID, true), gettype($cSPhoneID)), __LINE__);
        }
        $this->CSPhoneID = $cSPhoneID;
        return $this;
    }
    /**
     * Get IncludeNonIntrusionDeviceTroubles value
     * @return bool
     */
    public function getIncludeNonIntrusionDeviceTroubles()
    {
        return $this->IncludeNonIntrusionDeviceTroubles;
    }
    /**
     * Set IncludeNonIntrusionDeviceTroubles value
     * @param bool $includeNonIntrusionDeviceTroubles
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setIncludeNonIntrusionDeviceTroubles($includeNonIntrusionDeviceTroubles = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeNonIntrusionDeviceTroubles) && !is_bool($includeNonIntrusionDeviceTroubles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeNonIntrusionDeviceTroubles, true), gettype($includeNonIntrusionDeviceTroubles)), __LINE__);
        }
        $this->IncludeNonIntrusionDeviceTroubles = $includeNonIntrusionDeviceTroubles;
        return $this;
    }
    /**
     * Get EventGroupsToForward value
     * @return \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum|null
     */
    public function getEventGroupsToForward()
    {
        return $this->EventGroupsToForward;
    }
    /**
     * Set EventGroupsToForward value
     * @param \CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setEventGroupsToForward(\CustomerManagement\ArrayType\ArrayOfCentralStationEventGroupEnum $eventGroupsToForward = null)
    {
        $this->EventGroupsToForward = $eventGroupsToForward;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get ReceiverNumber value
     * @return string|null
     */
    public function getReceiverNumber()
    {
        return $this->ReceiverNumber;
    }
    /**
     * Set ReceiverNumber value
     * @param string $receiverNumber
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoInput
     */
    public function setReceiverNumber($receiverNumber = null)
    {
        // validation for constraint: string
        if (!is_null($receiverNumber) && !is_string($receiverNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverNumber, true), gettype($receiverNumber)), __LINE__);
        }
        $this->ReceiverNumber = $receiverNumber;
        return $this;
    }
}
