<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateBuildingName StructType
 * @subpackage Structs
 */
class UpdateBuildingName extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The buildingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $buildingName;
    /**
     * Constructor method for UpdateBuildingName
     * @uses UpdateBuildingName::setCustomerId()
     * @uses UpdateBuildingName::setBuildingName()
     * @param int $customerId
     * @param string $buildingName
     */
    public function __construct($customerId = null, $buildingName = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setBuildingName($buildingName);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateBuildingName
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get buildingName value
     * @return string|null
     */
    public function getBuildingName()
    {
        return $this->buildingName;
    }
    /**
     * Set buildingName value
     * @param string $buildingName
     * @return \CustomerManagement\StructType\UpdateBuildingName
     */
    public function setBuildingName($buildingName = null)
    {
        // validation for constraint: string
        if (!is_null($buildingName) && !is_string($buildingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingName, true), gettype($buildingName)), __LINE__);
        }
        $this->buildingName = $buildingName;
        return $this;
    }
}
