<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateApartmentSuiteName StructType
 * @subpackage Structs
 */
class UpdateApartmentSuiteName extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The apartmentSuiteName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $apartmentSuiteName;
    /**
     * Constructor method for UpdateApartmentSuiteName
     * @uses UpdateApartmentSuiteName::setCustomerId()
     * @uses UpdateApartmentSuiteName::setApartmentSuiteName()
     * @param int $customerId
     * @param string $apartmentSuiteName
     */
    public function __construct($customerId = null, $apartmentSuiteName = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setApartmentSuiteName($apartmentSuiteName);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateApartmentSuiteName
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get apartmentSuiteName value
     * @return string|null
     */
    public function getApartmentSuiteName()
    {
        return $this->apartmentSuiteName;
    }
    /**
     * Set apartmentSuiteName value
     * @param string $apartmentSuiteName
     * @return \CustomerManagement\StructType\UpdateApartmentSuiteName
     */
    public function setApartmentSuiteName($apartmentSuiteName = null)
    {
        // validation for constraint: string
        if (!is_null($apartmentSuiteName) && !is_string($apartmentSuiteName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apartmentSuiteName, true), gettype($apartmentSuiteName)), __LINE__);
        }
        $this->apartmentSuiteName = $apartmentSuiteName;
        return $this;
    }
}
