<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBusinessActivityAnalyticsScheduleInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfBusinessActivityAnalyticsScheduleInfo extends AbstractStructArrayBase
{
    /**
     * The BusinessActivityAnalyticsScheduleInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo[]
     */
    public $BusinessActivityAnalyticsScheduleInfo;
    /**
     * Constructor method for ArrayOfBusinessActivityAnalyticsScheduleInfo
     * @uses ArrayOfBusinessActivityAnalyticsScheduleInfo::setBusinessActivityAnalyticsScheduleInfo()
     * @param \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo[] $businessActivityAnalyticsScheduleInfo
     */
    public function __construct(array $businessActivityAnalyticsScheduleInfo = array())
    {
        $this
            ->setBusinessActivityAnalyticsScheduleInfo($businessActivityAnalyticsScheduleInfo);
    }
    /**
     * Get BusinessActivityAnalyticsScheduleInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo[]|null
     */
    public function getBusinessActivityAnalyticsScheduleInfo()
    {
        return isset($this->BusinessActivityAnalyticsScheduleInfo) ? $this->BusinessActivityAnalyticsScheduleInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessActivityAnalyticsScheduleInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessActivityAnalyticsScheduleInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessActivityAnalyticsScheduleInfoForArrayConstraintsFromSetBusinessActivityAnalyticsScheduleInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBusinessActivityAnalyticsScheduleInfoBusinessActivityAnalyticsScheduleInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfBusinessActivityAnalyticsScheduleInfoBusinessActivityAnalyticsScheduleInfoItem instanceof \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo) {
                $invalidValues[] = is_object($arrayOfBusinessActivityAnalyticsScheduleInfoBusinessActivityAnalyticsScheduleInfoItem) ? get_class($arrayOfBusinessActivityAnalyticsScheduleInfoBusinessActivityAnalyticsScheduleInfoItem) : sprintf('%s(%s)', gettype($arrayOfBusinessActivityAnalyticsScheduleInfoBusinessActivityAnalyticsScheduleInfoItem), var_export($arrayOfBusinessActivityAnalyticsScheduleInfoBusinessActivityAnalyticsScheduleInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessActivityAnalyticsScheduleInfo property can only contain items of type \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessActivityAnalyticsScheduleInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo[] $businessActivityAnalyticsScheduleInfo
     * @return \CustomerManagement\ArrayType\ArrayOfBusinessActivityAnalyticsScheduleInfo
     */
    public function setBusinessActivityAnalyticsScheduleInfo(array $businessActivityAnalyticsScheduleInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($businessActivityAnalyticsScheduleInfoArrayErrorMessage = self::validateBusinessActivityAnalyticsScheduleInfoForArrayConstraintsFromSetBusinessActivityAnalyticsScheduleInfo($businessActivityAnalyticsScheduleInfo))) {
            throw new \InvalidArgumentException($businessActivityAnalyticsScheduleInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($businessActivityAnalyticsScheduleInfo) || (is_array($businessActivityAnalyticsScheduleInfo) && empty($businessActivityAnalyticsScheduleInfo))) {
            unset($this->BusinessActivityAnalyticsScheduleInfo);
        } else {
            $this->BusinessActivityAnalyticsScheduleInfo = $businessActivityAnalyticsScheduleInfo;
        }
        return $this;
    }
    /**
     * Add item to BusinessActivityAnalyticsScheduleInfo value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo $item
     * @return \CustomerManagement\ArrayType\ArrayOfBusinessActivityAnalyticsScheduleInfo
     */
    public function addToBusinessActivityAnalyticsScheduleInfo(\CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo) {
            throw new \InvalidArgumentException(sprintf('The BusinessActivityAnalyticsScheduleInfo property can only contain items of type \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessActivityAnalyticsScheduleInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsScheduleInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BusinessActivityAnalyticsScheduleInfo
     */
    public function getAttributeName()
    {
        return 'BusinessActivityAnalyticsScheduleInfo';
    }
}
