<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeviceDetailInfo StructType
 * @subpackage Structs
 */
class DeviceDetailInfo extends AbstractStructBase
{
    /**
     * The DeviceNameInPanel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfString
     */
    public $DeviceNameInPanel;
    /**
     * The DeviceSerialCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceSerialCode;
    /**
     * The MACAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MACAddress;
    /**
     * Constructor method for DeviceDetailInfo
     * @uses DeviceDetailInfo::setDeviceNameInPanel()
     * @uses DeviceDetailInfo::setDeviceSerialCode()
     * @uses DeviceDetailInfo::setMACAddress()
     * @param \CustomerManagement\ArrayType\ArrayOfString $deviceNameInPanel
     * @param string $deviceSerialCode
     * @param string $mACAddress
     */
    public function __construct(\CustomerManagement\ArrayType\ArrayOfString $deviceNameInPanel = null, $deviceSerialCode = null, $mACAddress = null)
    {
        $this
            ->setDeviceNameInPanel($deviceNameInPanel)
            ->setDeviceSerialCode($deviceSerialCode)
            ->setMACAddress($mACAddress);
    }
    /**
     * Get DeviceNameInPanel value
     * @return \CustomerManagement\ArrayType\ArrayOfString|null
     */
    public function getDeviceNameInPanel()
    {
        return $this->DeviceNameInPanel;
    }
    /**
     * Set DeviceNameInPanel value
     * @param \CustomerManagement\ArrayType\ArrayOfString $deviceNameInPanel
     * @return \CustomerManagement\StructType\DeviceDetailInfo
     */
    public function setDeviceNameInPanel(\CustomerManagement\ArrayType\ArrayOfString $deviceNameInPanel = null)
    {
        $this->DeviceNameInPanel = $deviceNameInPanel;
        return $this;
    }
    /**
     * Get DeviceSerialCode value
     * @return string|null
     */
    public function getDeviceSerialCode()
    {
        return $this->DeviceSerialCode;
    }
    /**
     * Set DeviceSerialCode value
     * @param string $deviceSerialCode
     * @return \CustomerManagement\StructType\DeviceDetailInfo
     */
    public function setDeviceSerialCode($deviceSerialCode = null)
    {
        // validation for constraint: string
        if (!is_null($deviceSerialCode) && !is_string($deviceSerialCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceSerialCode, true), gettype($deviceSerialCode)), __LINE__);
        }
        $this->DeviceSerialCode = $deviceSerialCode;
        return $this;
    }
    /**
     * Get MACAddress value
     * @return string|null
     */
    public function getMACAddress()
    {
        return $this->MACAddress;
    }
    /**
     * Set MACAddress value
     * @param string $mACAddress
     * @return \CustomerManagement\StructType\DeviceDetailInfo
     */
    public function setMACAddress($mACAddress = null)
    {
        // validation for constraint: string
        if (!is_null($mACAddress) && !is_string($mACAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mACAddress, true), gettype($mACAddress)), __LINE__);
        }
        $this->MACAddress = $mACAddress;
        return $this;
    }
}
