<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerReadyDateInput StructType
 * @subpackage Structs
 */
class UpdateCustomerReadyDateInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The ReadyDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReadyDateUtc;
    /**
     * Constructor method for UpdateCustomerReadyDateInput
     * @uses UpdateCustomerReadyDateInput::setCustomerId()
     * @uses UpdateCustomerReadyDateInput::setReadyDateUtc()
     * @param int $customerId
     * @param string $readyDateUtc
     */
    public function __construct($customerId = null, $readyDateUtc = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setReadyDateUtc($readyDateUtc);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateCustomerReadyDateInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get ReadyDateUtc value
     * @return string
     */
    public function getReadyDateUtc()
    {
        return $this->ReadyDateUtc;
    }
    /**
     * Set ReadyDateUtc value
     * @param string $readyDateUtc
     * @return \CustomerManagement\StructType\UpdateCustomerReadyDateInput
     */
    public function setReadyDateUtc($readyDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($readyDateUtc) && !is_string($readyDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readyDateUtc, true), gettype($readyDateUtc)), __LINE__);
        }
        $this->ReadyDateUtc = $readyDateUtc;
        return $this;
    }
}
