<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerPackage ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerPackage extends AbstractStructArrayBase
{
    /**
     * The CustomerPackage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\CustomerPackage[]
     */
    public $CustomerPackage;
    /**
     * Constructor method for ArrayOfCustomerPackage
     * @uses ArrayOfCustomerPackage::setCustomerPackage()
     * @param \CustomerManagement\StructType\CustomerPackage[] $customerPackage
     */
    public function __construct(array $customerPackage = array())
    {
        $this
            ->setCustomerPackage($customerPackage);
    }
    /**
     * Get CustomerPackage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\CustomerPackage[]|null
     */
    public function getCustomerPackage()
    {
        return isset($this->CustomerPackage) ? $this->CustomerPackage : null;
    }
    /**
     * Set CustomerPackage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\CustomerPackage[] $customerPackage
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerPackage
     */
    public function setCustomerPackage(array $customerPackage = array())
    {
        foreach ($customerPackage as $arrayOfCustomerPackageCustomerPackageItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerPackageCustomerPackageItem instanceof \CustomerManagement\StructType\CustomerPackage) {
                throw new \InvalidArgumentException(sprintf('The CustomerPackage property can only contain items of \CustomerManagement\StructType\CustomerPackage, "%s" given', is_object($arrayOfCustomerPackageCustomerPackageItem) ? get_class($arrayOfCustomerPackageCustomerPackageItem) : gettype($arrayOfCustomerPackageCustomerPackageItem)), __LINE__);
            }
        }
        if (is_null($customerPackage) || (is_array($customerPackage) && empty($customerPackage))) {
            unset($this->CustomerPackage);
        } else {
            $this->CustomerPackage = $customerPackage;
        }
        return $this;
    }
    /**
     * Add item to CustomerPackage value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\CustomerPackage $item
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerPackage
     */
    public function addToCustomerPackage(\CustomerManagement\StructType\CustomerPackage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\CustomerPackage) {
            throw new \InvalidArgumentException(sprintf('The CustomerPackage property can only contain items of \CustomerManagement\StructType\CustomerPackage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerPackage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\CustomerPackage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\CustomerPackage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\CustomerPackage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\CustomerPackage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\CustomerPackage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerPackage
     */
    public function getAttributeName()
    {
        return 'CustomerPackage';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerPackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
