<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerTimeZoneInput StructType
 * @subpackage Structs
 */
class UpdateCustomerTimeZoneInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The TimeZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TimeZone;
    /**
     * Constructor method for UpdateCustomerTimeZoneInput
     * @uses UpdateCustomerTimeZoneInput::setCustomerId()
     * @uses UpdateCustomerTimeZoneInput::setTimeZone()
     * @param int $customerId
     * @param string $timeZone
     */
    public function __construct($customerId = null, $timeZone = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setTimeZone($timeZone);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateCustomerTimeZoneInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get TimeZone value
     * @return string
     */
    public function getTimeZone()
    {
        return $this->TimeZone;
    }
    /**
     * Set TimeZone value
     * @uses \CustomerManagement\EnumType\TimeZoneEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\TimeZoneEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return \CustomerManagement\StructType\UpdateCustomerTimeZoneInput
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\TimeZoneEnum::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\TimeZoneEnum', is_array($timeZone) ? implode(', ', $timeZone) : var_export($timeZone, true), implode(', ', \CustomerManagement\EnumType\TimeZoneEnum::getValidValues())), __LINE__);
        }
        $this->TimeZone = $timeZone;
        return $this;
    }
}
