<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWsPointAccessDeviceId ArrayType
 * @subpackage Arrays
 */
class ArrayOfWsPointAccessDeviceId extends AbstractStructArrayBase
{
    /**
     * The WsPointAccessDeviceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\WsPointAccessDeviceId[]
     */
    public $WsPointAccessDeviceId;
    /**
     * Constructor method for ArrayOfWsPointAccessDeviceId
     * @uses ArrayOfWsPointAccessDeviceId::setWsPointAccessDeviceId()
     * @param \CustomerManagement\StructType\WsPointAccessDeviceId[] $wsPointAccessDeviceId
     */
    public function __construct(array $wsPointAccessDeviceId = array())
    {
        $this
            ->setWsPointAccessDeviceId($wsPointAccessDeviceId);
    }
    /**
     * Get WsPointAccessDeviceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\WsPointAccessDeviceId[]|null
     */
    public function getWsPointAccessDeviceId()
    {
        return isset($this->WsPointAccessDeviceId) ? $this->WsPointAccessDeviceId : null;
    }
    /**
     * Set WsPointAccessDeviceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\WsPointAccessDeviceId[] $wsPointAccessDeviceId
     * @return \CustomerManagement\ArrayType\ArrayOfWsPointAccessDeviceId
     */
    public function setWsPointAccessDeviceId(array $wsPointAccessDeviceId = array())
    {
        foreach ($wsPointAccessDeviceId as $arrayOfWsPointAccessDeviceIdWsPointAccessDeviceIdItem) {
            // validation for constraint: itemType
            if (!$arrayOfWsPointAccessDeviceIdWsPointAccessDeviceIdItem instanceof \CustomerManagement\StructType\WsPointAccessDeviceId) {
                throw new \InvalidArgumentException(sprintf('The WsPointAccessDeviceId property can only contain items of \CustomerManagement\StructType\WsPointAccessDeviceId, "%s" given', is_object($arrayOfWsPointAccessDeviceIdWsPointAccessDeviceIdItem) ? get_class($arrayOfWsPointAccessDeviceIdWsPointAccessDeviceIdItem) : gettype($arrayOfWsPointAccessDeviceIdWsPointAccessDeviceIdItem)), __LINE__);
            }
        }
        if (is_null($wsPointAccessDeviceId) || (is_array($wsPointAccessDeviceId) && empty($wsPointAccessDeviceId))) {
            unset($this->WsPointAccessDeviceId);
        } else {
            $this->WsPointAccessDeviceId = $wsPointAccessDeviceId;
        }
        return $this;
    }
    /**
     * Add item to WsPointAccessDeviceId value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\WsPointAccessDeviceId $item
     * @return \CustomerManagement\ArrayType\ArrayOfWsPointAccessDeviceId
     */
    public function addToWsPointAccessDeviceId(\CustomerManagement\StructType\WsPointAccessDeviceId $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\WsPointAccessDeviceId) {
            throw new \InvalidArgumentException(sprintf('The WsPointAccessDeviceId property can only contain items of \CustomerManagement\StructType\WsPointAccessDeviceId, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WsPointAccessDeviceId[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\WsPointAccessDeviceId|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\WsPointAccessDeviceId|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\WsPointAccessDeviceId|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\WsPointAccessDeviceId|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\WsPointAccessDeviceId|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WsPointAccessDeviceId
     */
    public function getAttributeName()
    {
        return 'WsPointAccessDeviceId';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfWsPointAccessDeviceId
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
