<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventRecordItem StructType
 * @subpackage Structs
 */
class EventRecordItem extends AbstractStructBase
{
    /**
     * The Zone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Zone;
    /**
     * The Partition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Partition;
    /**
     * The TimestampUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TimestampUtc;
    /**
     * The Event
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Event;
    /**
     * Constructor method for EventRecordItem
     * @uses EventRecordItem::setZone()
     * @uses EventRecordItem::setPartition()
     * @uses EventRecordItem::setTimestampUtc()
     * @uses EventRecordItem::setEvent()
     * @param int $zone
     * @param int $partition
     * @param string $timestampUtc
     * @param string $event
     */
    public function __construct($zone = null, $partition = null, $timestampUtc = null, $event = null)
    {
        $this
            ->setZone($zone)
            ->setPartition($partition)
            ->setTimestampUtc($timestampUtc)
            ->setEvent($event);
    }
    /**
     * Get Zone value
     * @return int
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @param int $zone
     * @return \CustomerManagement\StructType\EventRecordItem
     */
    public function setZone($zone = null)
    {
        // validation for constraint: int
        if (!is_null($zone) && !(is_int($zone) || ctype_digit($zone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zone, true), gettype($zone)), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Get Partition value
     * @return int
     */
    public function getPartition()
    {
        return $this->Partition;
    }
    /**
     * Set Partition value
     * @param int $partition
     * @return \CustomerManagement\StructType\EventRecordItem
     */
    public function setPartition($partition = null)
    {
        // validation for constraint: int
        if (!is_null($partition) && !(is_int($partition) || ctype_digit($partition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partition, true), gettype($partition)), __LINE__);
        }
        $this->Partition = $partition;
        return $this;
    }
    /**
     * Get TimestampUtc value
     * @return string
     */
    public function getTimestampUtc()
    {
        return $this->TimestampUtc;
    }
    /**
     * Set TimestampUtc value
     * @param string $timestampUtc
     * @return \CustomerManagement\StructType\EventRecordItem
     */
    public function setTimestampUtc($timestampUtc = null)
    {
        // validation for constraint: string
        if (!is_null($timestampUtc) && !is_string($timestampUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestampUtc, true), gettype($timestampUtc)), __LINE__);
        }
        $this->TimestampUtc = $timestampUtc;
        return $this;
    }
    /**
     * Get Event value
     * @return string|null
     */
    public function getEvent()
    {
        return $this->Event;
    }
    /**
     * Set Event value
     * @param string $event
     * @return \CustomerManagement\StructType\EventRecordItem
     */
    public function setEvent($event = null)
    {
        // validation for constraint: string
        if (!is_null($event) && !is_string($event)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($event, true), gettype($event)), __LINE__);
        }
        $this->Event = $event;
        return $this;
    }
}
