<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateCommitmentForDealer StructType
 * @subpackage Structs
 */
class CreateCommitmentForDealer extends AbstractStructBase
{
    /**
     * The dealerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $dealerId;
    /**
     * The input
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\CreateCommitmentInput
     */
    public $input;
    /**
     * Constructor method for CreateCommitmentForDealer
     * @uses CreateCommitmentForDealer::setDealerId()
     * @uses CreateCommitmentForDealer::setInput()
     * @param int $dealerId
     * @param \CustomerManagement\StructType\CreateCommitmentInput $input
     */
    public function __construct($dealerId = null, \CustomerManagement\StructType\CreateCommitmentInput $input = null)
    {
        $this
            ->setDealerId($dealerId)
            ->setInput($input);
    }
    /**
     * Get dealerId value
     * @return int
     */
    public function getDealerId()
    {
        return $this->dealerId;
    }
    /**
     * Set dealerId value
     * @param int $dealerId
     * @return \CustomerManagement\StructType\CreateCommitmentForDealer
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: int
        if (!is_null($dealerId) && !(is_int($dealerId) || ctype_digit($dealerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealerId, true), gettype($dealerId)), __LINE__);
        }
        $this->dealerId = $dealerId;
        return $this;
    }
    /**
     * Get input value
     * @return \CustomerManagement\StructType\CreateCommitmentInput|null
     */
    public function getInput()
    {
        return $this->input;
    }
    /**
     * Set input value
     * @param \CustomerManagement\StructType\CreateCommitmentInput $input
     * @return \CustomerManagement\StructType\CreateCommitmentForDealer
     */
    public function setInput(\CustomerManagement\StructType\CreateCommitmentInput $input = null)
    {
        $this->input = $input;
        return $this;
    }
}
