<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateArmingScheduleInput StructType
 * @subpackage Structs
 */
class CreateArmingScheduleInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The NewArmingSchedule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\NewArmingSchedule
     */
    public $NewArmingSchedule;
    /**
     * Constructor method for CreateArmingScheduleInput
     * @uses CreateArmingScheduleInput::setCustomerId()
     * @uses CreateArmingScheduleInput::setNewArmingSchedule()
     * @param int $customerId
     * @param \CustomerManagement\StructType\NewArmingSchedule $newArmingSchedule
     */
    public function __construct($customerId = null, \CustomerManagement\StructType\NewArmingSchedule $newArmingSchedule = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setNewArmingSchedule($newArmingSchedule);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\CreateArmingScheduleInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get NewArmingSchedule value
     * @return \CustomerManagement\StructType\NewArmingSchedule|null
     */
    public function getNewArmingSchedule()
    {
        return $this->NewArmingSchedule;
    }
    /**
     * Set NewArmingSchedule value
     * @param \CustomerManagement\StructType\NewArmingSchedule $newArmingSchedule
     * @return \CustomerManagement\StructType\CreateArmingScheduleInput
     */
    public function setNewArmingSchedule(\CustomerManagement\StructType\NewArmingSchedule $newArmingSchedule = null)
    {
        $this->NewArmingSchedule = $newArmingSchedule;
        return $this;
    }
}
