<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestFirmwareUpgradeQolsysCell StructType
 * @subpackage Structs
 */
class RequestFirmwareUpgradeQolsysCell extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The newVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $newVersion;
    /**
     * The timeToUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $timeToUpdate;
    /**
     * The shouldUserAckMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $shouldUserAckMessage;
    /**
     * Constructor method for RequestFirmwareUpgradeQolsysCell
     * @uses RequestFirmwareUpgradeQolsysCell::setCustomerId()
     * @uses RequestFirmwareUpgradeQolsysCell::setNewVersion()
     * @uses RequestFirmwareUpgradeQolsysCell::setTimeToUpdate()
     * @uses RequestFirmwareUpgradeQolsysCell::setShouldUserAckMessage()
     * @param int $customerId
     * @param string $newVersion
     * @param string $timeToUpdate
     * @param bool $shouldUserAckMessage
     */
    public function __construct($customerId = null, $newVersion = null, $timeToUpdate = null, $shouldUserAckMessage = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setNewVersion($newVersion)
            ->setTimeToUpdate($timeToUpdate)
            ->setShouldUserAckMessage($shouldUserAckMessage);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\RequestFirmwareUpgradeQolsysCell
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get newVersion value
     * @return string
     */
    public function getNewVersion()
    {
        return $this->newVersion;
    }
    /**
     * Set newVersion value
     * @uses \CustomerManagement\EnumType\FirmwareUpgradeEnumQolsys::valueIsValid()
     * @uses \CustomerManagement\EnumType\FirmwareUpgradeEnumQolsys::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newVersion
     * @return \CustomerManagement\StructType\RequestFirmwareUpgradeQolsysCell
     */
    public function setNewVersion($newVersion = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\FirmwareUpgradeEnumQolsys::valueIsValid($newVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\FirmwareUpgradeEnumQolsys', is_array($newVersion) ? implode(', ', $newVersion) : var_export($newVersion, true), implode(', ', \CustomerManagement\EnumType\FirmwareUpgradeEnumQolsys::getValidValues())), __LINE__);
        }
        $this->newVersion = $newVersion;
        return $this;
    }
    /**
     * Get timeToUpdate value
     * @return string
     */
    public function getTimeToUpdate()
    {
        return $this->timeToUpdate;
    }
    /**
     * Set timeToUpdate value
     * @param string $timeToUpdate
     * @return \CustomerManagement\StructType\RequestFirmwareUpgradeQolsysCell
     */
    public function setTimeToUpdate($timeToUpdate = null)
    {
        // validation for constraint: string
        if (!is_null($timeToUpdate) && !is_string($timeToUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeToUpdate, true), gettype($timeToUpdate)), __LINE__);
        }
        $this->timeToUpdate = $timeToUpdate;
        return $this;
    }
    /**
     * Get shouldUserAckMessage value
     * @return bool
     */
    public function getShouldUserAckMessage()
    {
        return $this->shouldUserAckMessage;
    }
    /**
     * Set shouldUserAckMessage value
     * @param bool $shouldUserAckMessage
     * @return \CustomerManagement\StructType\RequestFirmwareUpgradeQolsysCell
     */
    public function setShouldUserAckMessage($shouldUserAckMessage = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldUserAckMessage) && !is_bool($shouldUserAckMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldUserAckMessage, true), gettype($shouldUserAckMessage)), __LINE__);
        }
        $this->shouldUserAckMessage = $shouldUserAckMessage;
        return $this;
    }
}
