<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBusinessActivityAnalyticsScheduleListOutput StructType
 * @subpackage Structs
 */
class GetBusinessActivityAnalyticsScheduleListOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Schedules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfBusinessActivityAnalyticsScheduleInfo
     */
    public $Schedules;
    /**
     * Constructor method for GetBusinessActivityAnalyticsScheduleListOutput
     * @uses GetBusinessActivityAnalyticsScheduleListOutput::setSuccess()
     * @uses GetBusinessActivityAnalyticsScheduleListOutput::setErrorMessage()
     * @uses GetBusinessActivityAnalyticsScheduleListOutput::setSchedules()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfBusinessActivityAnalyticsScheduleInfo $schedules
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfBusinessActivityAnalyticsScheduleInfo $schedules = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setSchedules($schedules);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetBusinessActivityAnalyticsScheduleListOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetBusinessActivityAnalyticsScheduleListOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Schedules value
     * @return \CustomerManagement\ArrayType\ArrayOfBusinessActivityAnalyticsScheduleInfo|null
     */
    public function getSchedules()
    {
        return $this->Schedules;
    }
    /**
     * Set Schedules value
     * @param \CustomerManagement\ArrayType\ArrayOfBusinessActivityAnalyticsScheduleInfo $schedules
     * @return \CustomerManagement\StructType\GetBusinessActivityAnalyticsScheduleListOutput
     */
    public function setSchedules(\CustomerManagement\ArrayType\ArrayOfBusinessActivityAnalyticsScheduleInfo $schedules = null)
    {
        $this->Schedules = $schedules;
        return $this;
    }
}
