<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSensorGroupInput StructType
 * @subpackage Structs
 */
class UpdateSensorGroupInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The SensorId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SensorId;
    /**
     * The PanelGroupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PanelGroupId;
    /**
     * Constructor method for UpdateSensorGroupInput
     * @uses UpdateSensorGroupInput::setCustomerId()
     * @uses UpdateSensorGroupInput::setSensorId()
     * @uses UpdateSensorGroupInput::setPanelGroupId()
     * @param int $customerId
     * @param int $sensorId
     * @param int $panelGroupId
     */
    public function __construct($customerId = null, $sensorId = null, $panelGroupId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setSensorId($sensorId)
            ->setPanelGroupId($panelGroupId);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateSensorGroupInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get SensorId value
     * @return int
     */
    public function getSensorId()
    {
        return $this->SensorId;
    }
    /**
     * Set SensorId value
     * @param int $sensorId
     * @return \CustomerManagement\StructType\UpdateSensorGroupInput
     */
    public function setSensorId($sensorId = null)
    {
        // validation for constraint: int
        if (!is_null($sensorId) && !(is_int($sensorId) || ctype_digit($sensorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sensorId, true), gettype($sensorId)), __LINE__);
        }
        $this->SensorId = $sensorId;
        return $this;
    }
    /**
     * Get PanelGroupId value
     * @return int
     */
    public function getPanelGroupId()
    {
        return $this->PanelGroupId;
    }
    /**
     * Set PanelGroupId value
     * @param int $panelGroupId
     * @return \CustomerManagement\StructType\UpdateSensorGroupInput
     */
    public function setPanelGroupId($panelGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($panelGroupId) && !(is_int($panelGroupId) || ctype_digit($panelGroupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($panelGroupId, true), gettype($panelGroupId)), __LINE__);
        }
        $this->PanelGroupId = $panelGroupId;
        return $this;
    }
}
