<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateEBSIntrusionDeviceInput StructType
 * @subpackage Structs
 */
class UpdateEBSIntrusionDeviceInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The Manufacturer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Manufacturer;
    /**
     * The Model
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Model;
    /**
     * The AcFailureTroubleConditionRestoreMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AcFailureTroubleConditionRestoreMethod;
    /**
     * The ManufacturerOther
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ManufacturerOther;
    /**
     * The ModelOther
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModelOther;
    /**
     * The FirmwareVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirmwareVersion;
    /**
     * The CommunicatorPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommunicatorPhoneNumber;
    /**
     * The AcFailureTroubleConditionRestoreCodeContactId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AcFailureTroubleConditionRestoreCodeContactId;
    /**
     * The AcFailureTroubleConditionRestoreCodeSIA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AcFailureTroubleConditionRestoreCodeSIA;
    /**
     * Constructor method for UpdateEBSIntrusionDeviceInput
     * @uses UpdateEBSIntrusionDeviceInput::setCustomerId()
     * @uses UpdateEBSIntrusionDeviceInput::setManufacturer()
     * @uses UpdateEBSIntrusionDeviceInput::setModel()
     * @uses UpdateEBSIntrusionDeviceInput::setAcFailureTroubleConditionRestoreMethod()
     * @uses UpdateEBSIntrusionDeviceInput::setManufacturerOther()
     * @uses UpdateEBSIntrusionDeviceInput::setModelOther()
     * @uses UpdateEBSIntrusionDeviceInput::setFirmwareVersion()
     * @uses UpdateEBSIntrusionDeviceInput::setCommunicatorPhoneNumber()
     * @uses UpdateEBSIntrusionDeviceInput::setAcFailureTroubleConditionRestoreCodeContactId()
     * @uses UpdateEBSIntrusionDeviceInput::setAcFailureTroubleConditionRestoreCodeSIA()
     * @param int $customerId
     * @param string $manufacturer
     * @param string $model
     * @param string $acFailureTroubleConditionRestoreMethod
     * @param string $manufacturerOther
     * @param string $modelOther
     * @param string $firmwareVersion
     * @param string $communicatorPhoneNumber
     * @param string $acFailureTroubleConditionRestoreCodeContactId
     * @param string $acFailureTroubleConditionRestoreCodeSIA
     */
    public function __construct($customerId = null, $manufacturer = null, $model = null, $acFailureTroubleConditionRestoreMethod = null, $manufacturerOther = null, $modelOther = null, $firmwareVersion = null, $communicatorPhoneNumber = null, $acFailureTroubleConditionRestoreCodeContactId = null, $acFailureTroubleConditionRestoreCodeSIA = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setManufacturer($manufacturer)
            ->setModel($model)
            ->setAcFailureTroubleConditionRestoreMethod($acFailureTroubleConditionRestoreMethod)
            ->setManufacturerOther($manufacturerOther)
            ->setModelOther($modelOther)
            ->setFirmwareVersion($firmwareVersion)
            ->setCommunicatorPhoneNumber($communicatorPhoneNumber)
            ->setAcFailureTroubleConditionRestoreCodeContactId($acFailureTroubleConditionRestoreCodeContactId)
            ->setAcFailureTroubleConditionRestoreCodeSIA($acFailureTroubleConditionRestoreCodeSIA);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateEBSIntrusionDeviceInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get Manufacturer value
     * @return string
     */
    public function getManufacturer()
    {
        return $this->Manufacturer;
    }
    /**
     * Set Manufacturer value
     * @uses \CustomerManagement\EnumType\EBSIntrusionManufacturerEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\EBSIntrusionManufacturerEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $manufacturer
     * @return \CustomerManagement\StructType\UpdateEBSIntrusionDeviceInput
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\EBSIntrusionManufacturerEnum::valueIsValid($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\EBSIntrusionManufacturerEnum', is_array($manufacturer) ? implode(', ', $manufacturer) : var_export($manufacturer, true), implode(', ', \CustomerManagement\EnumType\EBSIntrusionManufacturerEnum::getValidValues())), __LINE__);
        }
        $this->Manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get Model value
     * @return string
     */
    public function getModel()
    {
        return $this->Model;
    }
    /**
     * Set Model value
     * @uses \CustomerManagement\EnumType\EBSIntrusionModelEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\EBSIntrusionModelEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return \CustomerManagement\StructType\UpdateEBSIntrusionDeviceInput
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\EBSIntrusionModelEnum::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\EBSIntrusionModelEnum', is_array($model) ? implode(', ', $model) : var_export($model, true), implode(', ', \CustomerManagement\EnumType\EBSIntrusionModelEnum::getValidValues())), __LINE__);
        }
        $this->Model = $model;
        return $this;
    }
    /**
     * Get AcFailureTroubleConditionRestoreMethod value
     * @return string
     */
    public function getAcFailureTroubleConditionRestoreMethod()
    {
        return $this->AcFailureTroubleConditionRestoreMethod;
    }
    /**
     * Set AcFailureTroubleConditionRestoreMethod value
     * @uses \CustomerManagement\EnumType\EBSACFailureRestoreMethodEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\EBSACFailureRestoreMethodEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $acFailureTroubleConditionRestoreMethod
     * @return \CustomerManagement\StructType\UpdateEBSIntrusionDeviceInput
     */
    public function setAcFailureTroubleConditionRestoreMethod($acFailureTroubleConditionRestoreMethod = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\EBSACFailureRestoreMethodEnum::valueIsValid($acFailureTroubleConditionRestoreMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\EBSACFailureRestoreMethodEnum', is_array($acFailureTroubleConditionRestoreMethod) ? implode(', ', $acFailureTroubleConditionRestoreMethod) : var_export($acFailureTroubleConditionRestoreMethod, true), implode(', ', \CustomerManagement\EnumType\EBSACFailureRestoreMethodEnum::getValidValues())), __LINE__);
        }
        $this->AcFailureTroubleConditionRestoreMethod = $acFailureTroubleConditionRestoreMethod;
        return $this;
    }
    /**
     * Get ManufacturerOther value
     * @return string|null
     */
    public function getManufacturerOther()
    {
        return $this->ManufacturerOther;
    }
    /**
     * Set ManufacturerOther value
     * @param string $manufacturerOther
     * @return \CustomerManagement\StructType\UpdateEBSIntrusionDeviceInput
     */
    public function setManufacturerOther($manufacturerOther = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerOther) && !is_string($manufacturerOther)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerOther, true), gettype($manufacturerOther)), __LINE__);
        }
        $this->ManufacturerOther = $manufacturerOther;
        return $this;
    }
    /**
     * Get ModelOther value
     * @return string|null
     */
    public function getModelOther()
    {
        return $this->ModelOther;
    }
    /**
     * Set ModelOther value
     * @param string $modelOther
     * @return \CustomerManagement\StructType\UpdateEBSIntrusionDeviceInput
     */
    public function setModelOther($modelOther = null)
    {
        // validation for constraint: string
        if (!is_null($modelOther) && !is_string($modelOther)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modelOther, true), gettype($modelOther)), __LINE__);
        }
        $this->ModelOther = $modelOther;
        return $this;
    }
    /**
     * Get FirmwareVersion value
     * @return string|null
     */
    public function getFirmwareVersion()
    {
        return $this->FirmwareVersion;
    }
    /**
     * Set FirmwareVersion value
     * @param string $firmwareVersion
     * @return \CustomerManagement\StructType\UpdateEBSIntrusionDeviceInput
     */
    public function setFirmwareVersion($firmwareVersion = null)
    {
        // validation for constraint: string
        if (!is_null($firmwareVersion) && !is_string($firmwareVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firmwareVersion, true), gettype($firmwareVersion)), __LINE__);
        }
        $this->FirmwareVersion = $firmwareVersion;
        return $this;
    }
    /**
     * Get CommunicatorPhoneNumber value
     * @return string|null
     */
    public function getCommunicatorPhoneNumber()
    {
        return $this->CommunicatorPhoneNumber;
    }
    /**
     * Set CommunicatorPhoneNumber value
     * @param string $communicatorPhoneNumber
     * @return \CustomerManagement\StructType\UpdateEBSIntrusionDeviceInput
     */
    public function setCommunicatorPhoneNumber($communicatorPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($communicatorPhoneNumber) && !is_string($communicatorPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicatorPhoneNumber, true), gettype($communicatorPhoneNumber)), __LINE__);
        }
        $this->CommunicatorPhoneNumber = $communicatorPhoneNumber;
        return $this;
    }
    /**
     * Get AcFailureTroubleConditionRestoreCodeContactId value
     * @return string|null
     */
    public function getAcFailureTroubleConditionRestoreCodeContactId()
    {
        return $this->AcFailureTroubleConditionRestoreCodeContactId;
    }
    /**
     * Set AcFailureTroubleConditionRestoreCodeContactId value
     * @param string $acFailureTroubleConditionRestoreCodeContactId
     * @return \CustomerManagement\StructType\UpdateEBSIntrusionDeviceInput
     */
    public function setAcFailureTroubleConditionRestoreCodeContactId($acFailureTroubleConditionRestoreCodeContactId = null)
    {
        // validation for constraint: string
        if (!is_null($acFailureTroubleConditionRestoreCodeContactId) && !is_string($acFailureTroubleConditionRestoreCodeContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acFailureTroubleConditionRestoreCodeContactId, true), gettype($acFailureTroubleConditionRestoreCodeContactId)), __LINE__);
        }
        $this->AcFailureTroubleConditionRestoreCodeContactId = $acFailureTroubleConditionRestoreCodeContactId;
        return $this;
    }
    /**
     * Get AcFailureTroubleConditionRestoreCodeSIA value
     * @return string|null
     */
    public function getAcFailureTroubleConditionRestoreCodeSIA()
    {
        return $this->AcFailureTroubleConditionRestoreCodeSIA;
    }
    /**
     * Set AcFailureTroubleConditionRestoreCodeSIA value
     * @param string $acFailureTroubleConditionRestoreCodeSIA
     * @return \CustomerManagement\StructType\UpdateEBSIntrusionDeviceInput
     */
    public function setAcFailureTroubleConditionRestoreCodeSIA($acFailureTroubleConditionRestoreCodeSIA = null)
    {
        // validation for constraint: string
        if (!is_null($acFailureTroubleConditionRestoreCodeSIA) && !is_string($acFailureTroubleConditionRestoreCodeSIA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acFailureTroubleConditionRestoreCodeSIA, true), gettype($acFailureTroubleConditionRestoreCodeSIA)), __LINE__);
        }
        $this->AcFailureTroubleConditionRestoreCodeSIA = $acFailureTroubleConditionRestoreCodeSIA;
        return $this;
    }
}
