<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PauseUnpauseNotificationsInput StructType
 * @subpackage Structs
 */
class PauseUnpauseNotificationsInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The PauseNotificationsEnum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PauseNotificationsEnum;
    /**
     * Constructor method for PauseUnpauseNotificationsInput
     * @uses PauseUnpauseNotificationsInput::setCustomerId()
     * @uses PauseUnpauseNotificationsInput::setPauseNotificationsEnum()
     * @param int $customerId
     * @param string $pauseNotificationsEnum
     */
    public function __construct($customerId = null, $pauseNotificationsEnum = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setPauseNotificationsEnum($pauseNotificationsEnum);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\PauseUnpauseNotificationsInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get PauseNotificationsEnum value
     * @return string
     */
    public function getPauseNotificationsEnum()
    {
        return $this->PauseNotificationsEnum;
    }
    /**
     * Set PauseNotificationsEnum value
     * @uses \CustomerManagement\EnumType\PauseNotificationsEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PauseNotificationsEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pauseNotificationsEnum
     * @return \CustomerManagement\StructType\PauseUnpauseNotificationsInput
     */
    public function setPauseNotificationsEnum($pauseNotificationsEnum = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PauseNotificationsEnum::valueIsValid($pauseNotificationsEnum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PauseNotificationsEnum', is_array($pauseNotificationsEnum) ? implode(', ', $pauseNotificationsEnum) : var_export($pauseNotificationsEnum, true), implode(', ', \CustomerManagement\EnumType\PauseNotificationsEnum::getValidValues())), __LINE__);
        }
        $this->PauseNotificationsEnum = $pauseNotificationsEnum;
        return $this;
    }
}
