<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for APSFailure StructType
 * @subpackage Structs
 */
class APSFailure extends AbstractStructBase
{
    /**
     * The HasTroubleCondition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasTroubleCondition;
    /**
     * The FailingSinceUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FailingSinceUtc;
    /**
     * Constructor method for APSFailure
     * @uses APSFailure::setHasTroubleCondition()
     * @uses APSFailure::setFailingSinceUtc()
     * @param bool $hasTroubleCondition
     * @param string $failingSinceUtc
     */
    public function __construct($hasTroubleCondition = null, $failingSinceUtc = null)
    {
        $this
            ->setHasTroubleCondition($hasTroubleCondition)
            ->setFailingSinceUtc($failingSinceUtc);
    }
    /**
     * Get HasTroubleCondition value
     * @return bool
     */
    public function getHasTroubleCondition()
    {
        return $this->HasTroubleCondition;
    }
    /**
     * Set HasTroubleCondition value
     * @param bool $hasTroubleCondition
     * @return \CustomerManagement\StructType\APSFailure
     */
    public function setHasTroubleCondition($hasTroubleCondition = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasTroubleCondition) && !is_bool($hasTroubleCondition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasTroubleCondition, true), gettype($hasTroubleCondition)), __LINE__);
        }
        $this->HasTroubleCondition = $hasTroubleCondition;
        return $this;
    }
    /**
     * Get FailingSinceUtc value
     * @return string
     */
    public function getFailingSinceUtc()
    {
        return $this->FailingSinceUtc;
    }
    /**
     * Set FailingSinceUtc value
     * @param string $failingSinceUtc
     * @return \CustomerManagement\StructType\APSFailure
     */
    public function setFailingSinceUtc($failingSinceUtc = null)
    {
        // validation for constraint: string
        if (!is_null($failingSinceUtc) && !is_string($failingSinceUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failingSinceUtc, true), gettype($failingSinceUtc)), __LINE__);
        }
        $this->FailingSinceUtc = $failingSinceUtc;
        return $this;
    }
}
