<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerListInput StructType
 * @subpackage Structs
 */
class GetCustomerListInput extends AbstractStructBase
{
    /**
     * The IncludeTermed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IncludeTermed;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ExcludeCommitments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ExcludeCommitments;
    /**
     * The ExcludeCustomers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ExcludeCustomers;
    /**
     * The AlternateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AlternateId;
    /**
     * The PanelVersions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfPanelVersionEnum
     */
    public $PanelVersions;
    /**
     * Constructor method for GetCustomerListInput
     * @uses GetCustomerListInput::setIncludeTermed()
     * @uses GetCustomerListInput::setStartDate()
     * @uses GetCustomerListInput::setEndDate()
     * @uses GetCustomerListInput::setExcludeCommitments()
     * @uses GetCustomerListInput::setExcludeCustomers()
     * @uses GetCustomerListInput::setAlternateId()
     * @uses GetCustomerListInput::setPanelVersions()
     * @param bool $includeTermed
     * @param string $startDate
     * @param string $endDate
     * @param bool $excludeCommitments
     * @param bool $excludeCustomers
     * @param string $alternateId
     * @param \CustomerManagement\ArrayType\ArrayOfPanelVersionEnum $panelVersions
     */
    public function __construct($includeTermed = null, $startDate = null, $endDate = null, $excludeCommitments = null, $excludeCustomers = null, $alternateId = null, \CustomerManagement\ArrayType\ArrayOfPanelVersionEnum $panelVersions = null)
    {
        $this
            ->setIncludeTermed($includeTermed)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setExcludeCommitments($excludeCommitments)
            ->setExcludeCustomers($excludeCustomers)
            ->setAlternateId($alternateId)
            ->setPanelVersions($panelVersions);
    }
    /**
     * Get IncludeTermed value
     * @return bool
     */
    public function getIncludeTermed()
    {
        return $this->IncludeTermed;
    }
    /**
     * Set IncludeTermed value
     * @param bool $includeTermed
     * @return \CustomerManagement\StructType\GetCustomerListInput
     */
    public function setIncludeTermed($includeTermed = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTermed) && !is_bool($includeTermed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeTermed, true), gettype($includeTermed)), __LINE__);
        }
        $this->IncludeTermed = $includeTermed;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \CustomerManagement\StructType\GetCustomerListInput
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \CustomerManagement\StructType\GetCustomerListInput
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ExcludeCommitments value
     * @return bool
     */
    public function getExcludeCommitments()
    {
        return $this->ExcludeCommitments;
    }
    /**
     * Set ExcludeCommitments value
     * @param bool $excludeCommitments
     * @return \CustomerManagement\StructType\GetCustomerListInput
     */
    public function setExcludeCommitments($excludeCommitments = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeCommitments) && !is_bool($excludeCommitments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeCommitments, true), gettype($excludeCommitments)), __LINE__);
        }
        $this->ExcludeCommitments = $excludeCommitments;
        return $this;
    }
    /**
     * Get ExcludeCustomers value
     * @return bool
     */
    public function getExcludeCustomers()
    {
        return $this->ExcludeCustomers;
    }
    /**
     * Set ExcludeCustomers value
     * @param bool $excludeCustomers
     * @return \CustomerManagement\StructType\GetCustomerListInput
     */
    public function setExcludeCustomers($excludeCustomers = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeCustomers) && !is_bool($excludeCustomers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeCustomers, true), gettype($excludeCustomers)), __LINE__);
        }
        $this->ExcludeCustomers = $excludeCustomers;
        return $this;
    }
    /**
     * Get AlternateId value
     * @return string|null
     */
    public function getAlternateId()
    {
        return $this->AlternateId;
    }
    /**
     * Set AlternateId value
     * @param string $alternateId
     * @return \CustomerManagement\StructType\GetCustomerListInput
     */
    public function setAlternateId($alternateId = null)
    {
        // validation for constraint: string
        if (!is_null($alternateId) && !is_string($alternateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateId, true), gettype($alternateId)), __LINE__);
        }
        $this->AlternateId = $alternateId;
        return $this;
    }
    /**
     * Get PanelVersions value
     * @return \CustomerManagement\ArrayType\ArrayOfPanelVersionEnum|null
     */
    public function getPanelVersions()
    {
        return $this->PanelVersions;
    }
    /**
     * Set PanelVersions value
     * @param \CustomerManagement\ArrayType\ArrayOfPanelVersionEnum $panelVersions
     * @return \CustomerManagement\StructType\GetCustomerListInput
     */
    public function setPanelVersions(\CustomerManagement\ArrayType\ArrayOfPanelVersionEnum $panelVersions = null)
    {
        $this->PanelVersions = $panelVersions;
        return $this;
    }
}
