<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TenantTurnoverRequest StructType
 * @subpackage Structs
 */
class TenantTurnoverRequest extends AbstractStructBase
{
    /**
     * The CustomerIdForAccountRecycle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerIdForAccountRecycle;
    /**
     * The AccountRecycleReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AccountRecycleReason;
    /**
     * The GroupId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $GroupId;
    /**
     * The PackageId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PackageId;
    /**
     * The PackageTemplateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PackageTemplateId;
    /**
     * The DealerCustomerSourceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DealerCustomerSourceId;
    /**
     * The BuilderProgramId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BuilderProgramId;
    /**
     * The UseAddressFromAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $UseAddressFromAccount;
    /**
     * The PropertyType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PropertyType;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CountryCode;
    /**
     * The TimeZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TimeZone;
    /**
     * The UsingADCApp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $UsingADCApp;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The AlternativeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AlternativeId;
    /**
     * The LoginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginName;
    /**
     * The AddOnFeatures
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum
     */
    public $AddOnFeatures;
    /**
     * The CsAccountNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CsAccountNumber;
    /**
     * The MasterCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MasterCode;
    /**
     * The Street1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street1;
    /**
     * The Street2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street2;
    /**
     * The SubCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubCity;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The SubState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubState;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for TenantTurnoverRequest
     * @uses TenantTurnoverRequest::setCustomerIdForAccountRecycle()
     * @uses TenantTurnoverRequest::setAccountRecycleReason()
     * @uses TenantTurnoverRequest::setGroupId()
     * @uses TenantTurnoverRequest::setPackageId()
     * @uses TenantTurnoverRequest::setPackageTemplateId()
     * @uses TenantTurnoverRequest::setDealerCustomerSourceId()
     * @uses TenantTurnoverRequest::setBuilderProgramId()
     * @uses TenantTurnoverRequest::setUseAddressFromAccount()
     * @uses TenantTurnoverRequest::setPropertyType()
     * @uses TenantTurnoverRequest::setCountryCode()
     * @uses TenantTurnoverRequest::setTimeZone()
     * @uses TenantTurnoverRequest::setUsingADCApp()
     * @uses TenantTurnoverRequest::setFirstName()
     * @uses TenantTurnoverRequest::setLastName()
     * @uses TenantTurnoverRequest::setEmail()
     * @uses TenantTurnoverRequest::setPhoneNumber()
     * @uses TenantTurnoverRequest::setAlternativeId()
     * @uses TenantTurnoverRequest::setLoginName()
     * @uses TenantTurnoverRequest::setAddOnFeatures()
     * @uses TenantTurnoverRequest::setCsAccountNumber()
     * @uses TenantTurnoverRequest::setMasterCode()
     * @uses TenantTurnoverRequest::setStreet1()
     * @uses TenantTurnoverRequest::setStreet2()
     * @uses TenantTurnoverRequest::setSubCity()
     * @uses TenantTurnoverRequest::setCity()
     * @uses TenantTurnoverRequest::setSubState()
     * @uses TenantTurnoverRequest::setState()
     * @uses TenantTurnoverRequest::setZipCode()
     * @param int $customerIdForAccountRecycle
     * @param int $accountRecycleReason
     * @param int $groupId
     * @param int $packageId
     * @param int $packageTemplateId
     * @param int $dealerCustomerSourceId
     * @param int $builderProgramId
     * @param bool $useAddressFromAccount
     * @param int $propertyType
     * @param int $countryCode
     * @param int $timeZone
     * @param bool $usingADCApp
     * @param string $firstName
     * @param string $lastName
     * @param string $email
     * @param string $phoneNumber
     * @param string $alternativeId
     * @param string $loginName
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures
     * @param string $csAccountNumber
     * @param string $masterCode
     * @param string $street1
     * @param string $street2
     * @param string $subCity
     * @param string $city
     * @param string $subState
     * @param string $state
     * @param string $zipCode
     */
    public function __construct($customerIdForAccountRecycle = null, $accountRecycleReason = null, $groupId = null, $packageId = null, $packageTemplateId = null, $dealerCustomerSourceId = null, $builderProgramId = null, $useAddressFromAccount = null, $propertyType = null, $countryCode = null, $timeZone = null, $usingADCApp = null, $firstName = null, $lastName = null, $email = null, $phoneNumber = null, $alternativeId = null, $loginName = null, \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures = null, $csAccountNumber = null, $masterCode = null, $street1 = null, $street2 = null, $subCity = null, $city = null, $subState = null, $state = null, $zipCode = null)
    {
        $this
            ->setCustomerIdForAccountRecycle($customerIdForAccountRecycle)
            ->setAccountRecycleReason($accountRecycleReason)
            ->setGroupId($groupId)
            ->setPackageId($packageId)
            ->setPackageTemplateId($packageTemplateId)
            ->setDealerCustomerSourceId($dealerCustomerSourceId)
            ->setBuilderProgramId($builderProgramId)
            ->setUseAddressFromAccount($useAddressFromAccount)
            ->setPropertyType($propertyType)
            ->setCountryCode($countryCode)
            ->setTimeZone($timeZone)
            ->setUsingADCApp($usingADCApp)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setEmail($email)
            ->setPhoneNumber($phoneNumber)
            ->setAlternativeId($alternativeId)
            ->setLoginName($loginName)
            ->setAddOnFeatures($addOnFeatures)
            ->setCsAccountNumber($csAccountNumber)
            ->setMasterCode($masterCode)
            ->setStreet1($street1)
            ->setStreet2($street2)
            ->setSubCity($subCity)
            ->setCity($city)
            ->setSubState($subState)
            ->setState($state)
            ->setZipCode($zipCode);
    }
    /**
     * Get CustomerIdForAccountRecycle value
     * @return int
     */
    public function getCustomerIdForAccountRecycle()
    {
        return $this->CustomerIdForAccountRecycle;
    }
    /**
     * Set CustomerIdForAccountRecycle value
     * @param int $customerIdForAccountRecycle
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setCustomerIdForAccountRecycle($customerIdForAccountRecycle = null)
    {
        // validation for constraint: int
        if (!is_null($customerIdForAccountRecycle) && !(is_int($customerIdForAccountRecycle) || ctype_digit($customerIdForAccountRecycle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerIdForAccountRecycle, true), gettype($customerIdForAccountRecycle)), __LINE__);
        }
        $this->CustomerIdForAccountRecycle = $customerIdForAccountRecycle;
        return $this;
    }
    /**
     * Get AccountRecycleReason value
     * @return int
     */
    public function getAccountRecycleReason()
    {
        return $this->AccountRecycleReason;
    }
    /**
     * Set AccountRecycleReason value
     * @param int $accountRecycleReason
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setAccountRecycleReason($accountRecycleReason = null)
    {
        // validation for constraint: int
        if (!is_null($accountRecycleReason) && !(is_int($accountRecycleReason) || ctype_digit($accountRecycleReason))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountRecycleReason, true), gettype($accountRecycleReason)), __LINE__);
        }
        $this->AccountRecycleReason = $accountRecycleReason;
        return $this;
    }
    /**
     * Get GroupId value
     * @return int
     */
    public function getGroupId()
    {
        return $this->GroupId;
    }
    /**
     * Set GroupId value
     * @param int $groupId
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: int
        if (!is_null($groupId) && !(is_int($groupId) || ctype_digit($groupId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        $this->GroupId = $groupId;
        return $this;
    }
    /**
     * Get PackageId value
     * @return int
     */
    public function getPackageId()
    {
        return $this->PackageId;
    }
    /**
     * Set PackageId value
     * @param int $packageId
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: int
        if (!is_null($packageId) && !(is_int($packageId) || ctype_digit($packageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageId, true), gettype($packageId)), __LINE__);
        }
        $this->PackageId = $packageId;
        return $this;
    }
    /**
     * Get PackageTemplateId value
     * @return int
     */
    public function getPackageTemplateId()
    {
        return $this->PackageTemplateId;
    }
    /**
     * Set PackageTemplateId value
     * @param int $packageTemplateId
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setPackageTemplateId($packageTemplateId = null)
    {
        // validation for constraint: int
        if (!is_null($packageTemplateId) && !(is_int($packageTemplateId) || ctype_digit($packageTemplateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageTemplateId, true), gettype($packageTemplateId)), __LINE__);
        }
        $this->PackageTemplateId = $packageTemplateId;
        return $this;
    }
    /**
     * Get DealerCustomerSourceId value
     * @return int
     */
    public function getDealerCustomerSourceId()
    {
        return $this->DealerCustomerSourceId;
    }
    /**
     * Set DealerCustomerSourceId value
     * @param int $dealerCustomerSourceId
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setDealerCustomerSourceId($dealerCustomerSourceId = null)
    {
        // validation for constraint: int
        if (!is_null($dealerCustomerSourceId) && !(is_int($dealerCustomerSourceId) || ctype_digit($dealerCustomerSourceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealerCustomerSourceId, true), gettype($dealerCustomerSourceId)), __LINE__);
        }
        $this->DealerCustomerSourceId = $dealerCustomerSourceId;
        return $this;
    }
    /**
     * Get BuilderProgramId value
     * @return int
     */
    public function getBuilderProgramId()
    {
        return $this->BuilderProgramId;
    }
    /**
     * Set BuilderProgramId value
     * @param int $builderProgramId
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setBuilderProgramId($builderProgramId = null)
    {
        // validation for constraint: int
        if (!is_null($builderProgramId) && !(is_int($builderProgramId) || ctype_digit($builderProgramId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($builderProgramId, true), gettype($builderProgramId)), __LINE__);
        }
        $this->BuilderProgramId = $builderProgramId;
        return $this;
    }
    /**
     * Get UseAddressFromAccount value
     * @return bool
     */
    public function getUseAddressFromAccount()
    {
        return $this->UseAddressFromAccount;
    }
    /**
     * Set UseAddressFromAccount value
     * @param bool $useAddressFromAccount
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setUseAddressFromAccount($useAddressFromAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($useAddressFromAccount) && !is_bool($useAddressFromAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useAddressFromAccount, true), gettype($useAddressFromAccount)), __LINE__);
        }
        $this->UseAddressFromAccount = $useAddressFromAccount;
        return $this;
    }
    /**
     * Get PropertyType value
     * @return int
     */
    public function getPropertyType()
    {
        return $this->PropertyType;
    }
    /**
     * Set PropertyType value
     * @param int $propertyType
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setPropertyType($propertyType = null)
    {
        // validation for constraint: int
        if (!is_null($propertyType) && !(is_int($propertyType) || ctype_digit($propertyType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($propertyType, true), gettype($propertyType)), __LINE__);
        }
        $this->PropertyType = $propertyType;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return int
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param int $countryCode
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: int
        if (!is_null($countryCode) && !(is_int($countryCode) || ctype_digit($countryCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get TimeZone value
     * @return int
     */
    public function getTimeZone()
    {
        return $this->TimeZone;
    }
    /**
     * Set TimeZone value
     * @param int $timeZone
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: int
        if (!is_null($timeZone) && !(is_int($timeZone) || ctype_digit($timeZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeZone, true), gettype($timeZone)), __LINE__);
        }
        $this->TimeZone = $timeZone;
        return $this;
    }
    /**
     * Get UsingADCApp value
     * @return bool
     */
    public function getUsingADCApp()
    {
        return $this->UsingADCApp;
    }
    /**
     * Set UsingADCApp value
     * @param bool $usingADCApp
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setUsingADCApp($usingADCApp = null)
    {
        // validation for constraint: boolean
        if (!is_null($usingADCApp) && !is_bool($usingADCApp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usingADCApp, true), gettype($usingADCApp)), __LINE__);
        }
        $this->UsingADCApp = $usingADCApp;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get AlternativeId value
     * @return string|null
     */
    public function getAlternativeId()
    {
        return $this->AlternativeId;
    }
    /**
     * Set AlternativeId value
     * @param string $alternativeId
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setAlternativeId($alternativeId = null)
    {
        // validation for constraint: string
        if (!is_null($alternativeId) && !is_string($alternativeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternativeId, true), gettype($alternativeId)), __LINE__);
        }
        $this->AlternativeId = $alternativeId;
        return $this;
    }
    /**
     * Get LoginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->LoginName;
    }
    /**
     * Set LoginName value
     * @param string $loginName
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        $this->LoginName = $loginName;
        return $this;
    }
    /**
     * Get AddOnFeatures value
     * @return \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum|null
     */
    public function getAddOnFeatures()
    {
        return $this->AddOnFeatures;
    }
    /**
     * Set AddOnFeatures value
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setAddOnFeatures(\CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addOnFeatures = null)
    {
        $this->AddOnFeatures = $addOnFeatures;
        return $this;
    }
    /**
     * Get CsAccountNumber value
     * @return string|null
     */
    public function getCsAccountNumber()
    {
        return $this->CsAccountNumber;
    }
    /**
     * Set CsAccountNumber value
     * @param string $csAccountNumber
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setCsAccountNumber($csAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($csAccountNumber) && !is_string($csAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($csAccountNumber, true), gettype($csAccountNumber)), __LINE__);
        }
        $this->CsAccountNumber = $csAccountNumber;
        return $this;
    }
    /**
     * Get MasterCode value
     * @return string|null
     */
    public function getMasterCode()
    {
        return $this->MasterCode;
    }
    /**
     * Set MasterCode value
     * @param string $masterCode
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setMasterCode($masterCode = null)
    {
        // validation for constraint: string
        if (!is_null($masterCode) && !is_string($masterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterCode, true), gettype($masterCode)), __LINE__);
        }
        $this->MasterCode = $masterCode;
        return $this;
    }
    /**
     * Get Street1 value
     * @return string|null
     */
    public function getStreet1()
    {
        return $this->Street1;
    }
    /**
     * Set Street1 value
     * @param string $street1
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setStreet1($street1 = null)
    {
        // validation for constraint: string
        if (!is_null($street1) && !is_string($street1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street1, true), gettype($street1)), __LINE__);
        }
        $this->Street1 = $street1;
        return $this;
    }
    /**
     * Get Street2 value
     * @return string|null
     */
    public function getStreet2()
    {
        return $this->Street2;
    }
    /**
     * Set Street2 value
     * @param string $street2
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setStreet2($street2 = null)
    {
        // validation for constraint: string
        if (!is_null($street2) && !is_string($street2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street2, true), gettype($street2)), __LINE__);
        }
        $this->Street2 = $street2;
        return $this;
    }
    /**
     * Get SubCity value
     * @return string|null
     */
    public function getSubCity()
    {
        return $this->SubCity;
    }
    /**
     * Set SubCity value
     * @param string $subCity
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setSubCity($subCity = null)
    {
        // validation for constraint: string
        if (!is_null($subCity) && !is_string($subCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCity, true), gettype($subCity)), __LINE__);
        }
        $this->SubCity = $subCity;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get SubState value
     * @return string|null
     */
    public function getSubState()
    {
        return $this->SubState;
    }
    /**
     * Set SubState value
     * @param string $subState
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setSubState($subState = null)
    {
        // validation for constraint: string
        if (!is_null($subState) && !is_string($subState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subState, true), gettype($subState)), __LINE__);
        }
        $this->SubState = $subState;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \CustomerManagement\StructType\TenantTurnoverRequest
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
}
