<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerListWithTroubleConditionsInput StructType
 * @subpackage Structs
 */
class GetCustomerListWithTroubleConditionsInput extends AbstractStructBase
{
    /**
     * The CallerVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CallerVersion;
    /**
     * The IncludeDeviceDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeDeviceDetails;
    /**
     * The MinStartDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MinStartDateUtc;
    /**
     * The MaxStartDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MaxStartDateUtc;
    /**
     * The Conditions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum
     */
    public $Conditions;
    /**
     * Constructor method for GetCustomerListWithTroubleConditionsInput
     * @uses GetCustomerListWithTroubleConditionsInput::setCallerVersion()
     * @uses GetCustomerListWithTroubleConditionsInput::setIncludeDeviceDetails()
     * @uses GetCustomerListWithTroubleConditionsInput::setMinStartDateUtc()
     * @uses GetCustomerListWithTroubleConditionsInput::setMaxStartDateUtc()
     * @uses GetCustomerListWithTroubleConditionsInput::setConditions()
     * @param int $callerVersion
     * @param bool $includeDeviceDetails
     * @param string $minStartDateUtc
     * @param string $maxStartDateUtc
     * @param \CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum $conditions
     */
    public function __construct($callerVersion = null, $includeDeviceDetails = null, $minStartDateUtc = null, $maxStartDateUtc = null, \CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum $conditions = null)
    {
        $this
            ->setCallerVersion($callerVersion)
            ->setIncludeDeviceDetails($includeDeviceDetails)
            ->setMinStartDateUtc($minStartDateUtc)
            ->setMaxStartDateUtc($maxStartDateUtc)
            ->setConditions($conditions);
    }
    /**
     * Get CallerVersion value
     * @return int
     */
    public function getCallerVersion()
    {
        return $this->CallerVersion;
    }
    /**
     * Set CallerVersion value
     * @param int $callerVersion
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsInput
     */
    public function setCallerVersion($callerVersion = null)
    {
        // validation for constraint: int
        if (!is_null($callerVersion) && !(is_int($callerVersion) || ctype_digit($callerVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($callerVersion, true), gettype($callerVersion)), __LINE__);
        }
        $this->CallerVersion = $callerVersion;
        return $this;
    }
    /**
     * Get IncludeDeviceDetails value
     * @return bool
     */
    public function getIncludeDeviceDetails()
    {
        return $this->IncludeDeviceDetails;
    }
    /**
     * Set IncludeDeviceDetails value
     * @param bool $includeDeviceDetails
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsInput
     */
    public function setIncludeDeviceDetails($includeDeviceDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeDeviceDetails) && !is_bool($includeDeviceDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeDeviceDetails, true), gettype($includeDeviceDetails)), __LINE__);
        }
        $this->IncludeDeviceDetails = $includeDeviceDetails;
        return $this;
    }
    /**
     * Get MinStartDateUtc value
     * @return string
     */
    public function getMinStartDateUtc()
    {
        return $this->MinStartDateUtc;
    }
    /**
     * Set MinStartDateUtc value
     * @param string $minStartDateUtc
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsInput
     */
    public function setMinStartDateUtc($minStartDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($minStartDateUtc) && !is_string($minStartDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minStartDateUtc, true), gettype($minStartDateUtc)), __LINE__);
        }
        $this->MinStartDateUtc = $minStartDateUtc;
        return $this;
    }
    /**
     * Get MaxStartDateUtc value
     * @return string
     */
    public function getMaxStartDateUtc()
    {
        return $this->MaxStartDateUtc;
    }
    /**
     * Set MaxStartDateUtc value
     * @param string $maxStartDateUtc
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsInput
     */
    public function setMaxStartDateUtc($maxStartDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($maxStartDateUtc) && !is_string($maxStartDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxStartDateUtc, true), gettype($maxStartDateUtc)), __LINE__);
        }
        $this->MaxStartDateUtc = $maxStartDateUtc;
        return $this;
    }
    /**
     * Get Conditions value
     * @return \CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum|null
     */
    public function getConditions()
    {
        return $this->Conditions;
    }
    /**
     * Set Conditions value
     * @param \CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum $conditions
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsInput
     */
    public function setConditions(\CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum $conditions = null)
    {
        $this->Conditions = $conditions;
        return $this;
    }
}
