<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerBestPracticesOutput StructType
 * @subpackage Structs
 */
class CustomerBestPracticesOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The CheckedCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CheckedCount;
    /**
     * The EmailVerified
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EmailVerified;
    /**
     * The MobileContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MobileContact;
    /**
     * The ArmingReminder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ArmingReminder;
    /**
     * The GeoDevice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $GeoDevice;
    /**
     * The AdvancedDevice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AdvancedDevice;
    /**
     * The RuleOrSchedule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RuleOrSchedule;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Scores
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfBestPracticeRecord
     */
    public $Scores;
    /**
     * Constructor method for CustomerBestPracticesOutput
     * @uses CustomerBestPracticesOutput::setSuccess()
     * @uses CustomerBestPracticesOutput::setCheckedCount()
     * @uses CustomerBestPracticesOutput::setEmailVerified()
     * @uses CustomerBestPracticesOutput::setMobileContact()
     * @uses CustomerBestPracticesOutput::setArmingReminder()
     * @uses CustomerBestPracticesOutput::setGeoDevice()
     * @uses CustomerBestPracticesOutput::setAdvancedDevice()
     * @uses CustomerBestPracticesOutput::setRuleOrSchedule()
     * @uses CustomerBestPracticesOutput::setErrorMessage()
     * @uses CustomerBestPracticesOutput::setScores()
     * @param bool $success
     * @param int $checkedCount
     * @param bool $emailVerified
     * @param bool $mobileContact
     * @param bool $armingReminder
     * @param bool $geoDevice
     * @param bool $advancedDevice
     * @param bool $ruleOrSchedule
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfBestPracticeRecord $scores
     */
    public function __construct($success = null, $checkedCount = null, $emailVerified = null, $mobileContact = null, $armingReminder = null, $geoDevice = null, $advancedDevice = null, $ruleOrSchedule = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfBestPracticeRecord $scores = null)
    {
        $this
            ->setSuccess($success)
            ->setCheckedCount($checkedCount)
            ->setEmailVerified($emailVerified)
            ->setMobileContact($mobileContact)
            ->setArmingReminder($armingReminder)
            ->setGeoDevice($geoDevice)
            ->setAdvancedDevice($advancedDevice)
            ->setRuleOrSchedule($ruleOrSchedule)
            ->setErrorMessage($errorMessage)
            ->setScores($scores);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\CustomerBestPracticesOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get CheckedCount value
     * @return int
     */
    public function getCheckedCount()
    {
        return $this->CheckedCount;
    }
    /**
     * Set CheckedCount value
     * @param int $checkedCount
     * @return \CustomerManagement\StructType\CustomerBestPracticesOutput
     */
    public function setCheckedCount($checkedCount = null)
    {
        // validation for constraint: int
        if (!is_null($checkedCount) && !(is_int($checkedCount) || ctype_digit($checkedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($checkedCount, true), gettype($checkedCount)), __LINE__);
        }
        $this->CheckedCount = $checkedCount;
        return $this;
    }
    /**
     * Get EmailVerified value
     * @return bool
     */
    public function getEmailVerified()
    {
        return $this->EmailVerified;
    }
    /**
     * Set EmailVerified value
     * @param bool $emailVerified
     * @return \CustomerManagement\StructType\CustomerBestPracticesOutput
     */
    public function setEmailVerified($emailVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailVerified) && !is_bool($emailVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailVerified, true), gettype($emailVerified)), __LINE__);
        }
        $this->EmailVerified = $emailVerified;
        return $this;
    }
    /**
     * Get MobileContact value
     * @return bool
     */
    public function getMobileContact()
    {
        return $this->MobileContact;
    }
    /**
     * Set MobileContact value
     * @param bool $mobileContact
     * @return \CustomerManagement\StructType\CustomerBestPracticesOutput
     */
    public function setMobileContact($mobileContact = null)
    {
        // validation for constraint: boolean
        if (!is_null($mobileContact) && !is_bool($mobileContact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mobileContact, true), gettype($mobileContact)), __LINE__);
        }
        $this->MobileContact = $mobileContact;
        return $this;
    }
    /**
     * Get ArmingReminder value
     * @return bool
     */
    public function getArmingReminder()
    {
        return $this->ArmingReminder;
    }
    /**
     * Set ArmingReminder value
     * @param bool $armingReminder
     * @return \CustomerManagement\StructType\CustomerBestPracticesOutput
     */
    public function setArmingReminder($armingReminder = null)
    {
        // validation for constraint: boolean
        if (!is_null($armingReminder) && !is_bool($armingReminder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($armingReminder, true), gettype($armingReminder)), __LINE__);
        }
        $this->ArmingReminder = $armingReminder;
        return $this;
    }
    /**
     * Get GeoDevice value
     * @return bool
     */
    public function getGeoDevice()
    {
        return $this->GeoDevice;
    }
    /**
     * Set GeoDevice value
     * @param bool $geoDevice
     * @return \CustomerManagement\StructType\CustomerBestPracticesOutput
     */
    public function setGeoDevice($geoDevice = null)
    {
        // validation for constraint: boolean
        if (!is_null($geoDevice) && !is_bool($geoDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($geoDevice, true), gettype($geoDevice)), __LINE__);
        }
        $this->GeoDevice = $geoDevice;
        return $this;
    }
    /**
     * Get AdvancedDevice value
     * @return bool
     */
    public function getAdvancedDevice()
    {
        return $this->AdvancedDevice;
    }
    /**
     * Set AdvancedDevice value
     * @param bool $advancedDevice
     * @return \CustomerManagement\StructType\CustomerBestPracticesOutput
     */
    public function setAdvancedDevice($advancedDevice = null)
    {
        // validation for constraint: boolean
        if (!is_null($advancedDevice) && !is_bool($advancedDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($advancedDevice, true), gettype($advancedDevice)), __LINE__);
        }
        $this->AdvancedDevice = $advancedDevice;
        return $this;
    }
    /**
     * Get RuleOrSchedule value
     * @return bool
     */
    public function getRuleOrSchedule()
    {
        return $this->RuleOrSchedule;
    }
    /**
     * Set RuleOrSchedule value
     * @param bool $ruleOrSchedule
     * @return \CustomerManagement\StructType\CustomerBestPracticesOutput
     */
    public function setRuleOrSchedule($ruleOrSchedule = null)
    {
        // validation for constraint: boolean
        if (!is_null($ruleOrSchedule) && !is_bool($ruleOrSchedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ruleOrSchedule, true), gettype($ruleOrSchedule)), __LINE__);
        }
        $this->RuleOrSchedule = $ruleOrSchedule;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\CustomerBestPracticesOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Scores value
     * @return \CustomerManagement\ArrayType\ArrayOfBestPracticeRecord|null
     */
    public function getScores()
    {
        return $this->Scores;
    }
    /**
     * Set Scores value
     * @param \CustomerManagement\ArrayType\ArrayOfBestPracticeRecord $scores
     * @return \CustomerManagement\StructType\CustomerBestPracticesOutput
     */
    public function setScores(\CustomerManagement\ArrayType\ArrayOfBestPracticeRecord $scores = null)
    {
        $this->Scores = $scores;
        return $this;
    }
}
