<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessActivityAnalyticsMetricInfo StructType
 * @subpackage Structs
 */
class BusinessActivityAnalyticsMetricInfo extends AbstractStructBase
{
    /**
     * The OccupancyCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OccupancyCount;
    /**
     * The WaitTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WaitTime;
    /**
     * The TodaysTraffic
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TodaysTraffic;
    /**
     * The HistoricalAvgTrafficDaySoFar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $HistoricalAvgTrafficDaySoFar;
    /**
     * The HistoricalAvgTrafficFullDay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $HistoricalAvgTrafficFullDay;
    /**
     * The TimestampLocal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimestampLocal;
    /**
     * Constructor method for BusinessActivityAnalyticsMetricInfo
     * @uses BusinessActivityAnalyticsMetricInfo::setOccupancyCount()
     * @uses BusinessActivityAnalyticsMetricInfo::setWaitTime()
     * @uses BusinessActivityAnalyticsMetricInfo::setTodaysTraffic()
     * @uses BusinessActivityAnalyticsMetricInfo::setHistoricalAvgTrafficDaySoFar()
     * @uses BusinessActivityAnalyticsMetricInfo::setHistoricalAvgTrafficFullDay()
     * @uses BusinessActivityAnalyticsMetricInfo::setTimestampLocal()
     * @param int $occupancyCount
     * @param int $waitTime
     * @param int $todaysTraffic
     * @param int $historicalAvgTrafficDaySoFar
     * @param int $historicalAvgTrafficFullDay
     * @param string $timestampLocal
     */
    public function __construct($occupancyCount = null, $waitTime = null, $todaysTraffic = null, $historicalAvgTrafficDaySoFar = null, $historicalAvgTrafficFullDay = null, $timestampLocal = null)
    {
        $this
            ->setOccupancyCount($occupancyCount)
            ->setWaitTime($waitTime)
            ->setTodaysTraffic($todaysTraffic)
            ->setHistoricalAvgTrafficDaySoFar($historicalAvgTrafficDaySoFar)
            ->setHistoricalAvgTrafficFullDay($historicalAvgTrafficFullDay)
            ->setTimestampLocal($timestampLocal);
    }
    /**
     * Get OccupancyCount value
     * @return int
     */
    public function getOccupancyCount()
    {
        return $this->OccupancyCount;
    }
    /**
     * Set OccupancyCount value
     * @param int $occupancyCount
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsMetricInfo
     */
    public function setOccupancyCount($occupancyCount = null)
    {
        // validation for constraint: int
        if (!is_null($occupancyCount) && !(is_int($occupancyCount) || ctype_digit($occupancyCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($occupancyCount, true), gettype($occupancyCount)), __LINE__);
        }
        $this->OccupancyCount = $occupancyCount;
        return $this;
    }
    /**
     * Get WaitTime value
     * @return int
     */
    public function getWaitTime()
    {
        return $this->WaitTime;
    }
    /**
     * Set WaitTime value
     * @param int $waitTime
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsMetricInfo
     */
    public function setWaitTime($waitTime = null)
    {
        // validation for constraint: int
        if (!is_null($waitTime) && !(is_int($waitTime) || ctype_digit($waitTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waitTime, true), gettype($waitTime)), __LINE__);
        }
        $this->WaitTime = $waitTime;
        return $this;
    }
    /**
     * Get TodaysTraffic value
     * @return int
     */
    public function getTodaysTraffic()
    {
        return $this->TodaysTraffic;
    }
    /**
     * Set TodaysTraffic value
     * @param int $todaysTraffic
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsMetricInfo
     */
    public function setTodaysTraffic($todaysTraffic = null)
    {
        // validation for constraint: int
        if (!is_null($todaysTraffic) && !(is_int($todaysTraffic) || ctype_digit($todaysTraffic))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($todaysTraffic, true), gettype($todaysTraffic)), __LINE__);
        }
        $this->TodaysTraffic = $todaysTraffic;
        return $this;
    }
    /**
     * Get HistoricalAvgTrafficDaySoFar value
     * @return int
     */
    public function getHistoricalAvgTrafficDaySoFar()
    {
        return $this->HistoricalAvgTrafficDaySoFar;
    }
    /**
     * Set HistoricalAvgTrafficDaySoFar value
     * @param int $historicalAvgTrafficDaySoFar
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsMetricInfo
     */
    public function setHistoricalAvgTrafficDaySoFar($historicalAvgTrafficDaySoFar = null)
    {
        // validation for constraint: int
        if (!is_null($historicalAvgTrafficDaySoFar) && !(is_int($historicalAvgTrafficDaySoFar) || ctype_digit($historicalAvgTrafficDaySoFar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($historicalAvgTrafficDaySoFar, true), gettype($historicalAvgTrafficDaySoFar)), __LINE__);
        }
        $this->HistoricalAvgTrafficDaySoFar = $historicalAvgTrafficDaySoFar;
        return $this;
    }
    /**
     * Get HistoricalAvgTrafficFullDay value
     * @return int
     */
    public function getHistoricalAvgTrafficFullDay()
    {
        return $this->HistoricalAvgTrafficFullDay;
    }
    /**
     * Set HistoricalAvgTrafficFullDay value
     * @param int $historicalAvgTrafficFullDay
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsMetricInfo
     */
    public function setHistoricalAvgTrafficFullDay($historicalAvgTrafficFullDay = null)
    {
        // validation for constraint: int
        if (!is_null($historicalAvgTrafficFullDay) && !(is_int($historicalAvgTrafficFullDay) || ctype_digit($historicalAvgTrafficFullDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($historicalAvgTrafficFullDay, true), gettype($historicalAvgTrafficFullDay)), __LINE__);
        }
        $this->HistoricalAvgTrafficFullDay = $historicalAvgTrafficFullDay;
        return $this;
    }
    /**
     * Get TimestampLocal value
     * @return string|null
     */
    public function getTimestampLocal()
    {
        return $this->TimestampLocal;
    }
    /**
     * Set TimestampLocal value
     * @param string $timestampLocal
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsMetricInfo
     */
    public function setTimestampLocal($timestampLocal = null)
    {
        // validation for constraint: string
        if (!is_null($timestampLocal) && !is_string($timestampLocal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestampLocal, true), gettype($timestampLocal)), __LINE__);
        }
        $this->TimestampLocal = $timestampLocal;
        return $this;
    }
}
