<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TerminateCustomer StructType
 * @subpackage Structs
 */
class TerminateCustomer extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The accountTerminateReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $accountTerminateReason;
    /**
     * Constructor method for TerminateCustomer
     * @uses TerminateCustomer::setCustomerId()
     * @uses TerminateCustomer::setAccountTerminateReason()
     * @param int $customerId
     * @param string $accountTerminateReason
     */
    public function __construct($customerId = null, $accountTerminateReason = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setAccountTerminateReason($accountTerminateReason);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\TerminateCustomer
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get accountTerminateReason value
     * @return string
     */
    public function getAccountTerminateReason()
    {
        return $this->accountTerminateReason;
    }
    /**
     * Set accountTerminateReason value
     * @uses \CustomerManagement\EnumType\CustomerTerminateReasonEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CustomerTerminateReasonEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountTerminateReason
     * @return \CustomerManagement\StructType\TerminateCustomer
     */
    public function setAccountTerminateReason($accountTerminateReason = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CustomerTerminateReasonEnum::valueIsValid($accountTerminateReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CustomerTerminateReasonEnum', is_array($accountTerminateReason) ? implode(', ', $accountTerminateReason) : var_export($accountTerminateReason, true), implode(', ', \CustomerManagement\EnumType\CustomerTerminateReasonEnum::getValidValues())), __LINE__);
        }
        $this->accountTerminateReason = $accountTerminateReason;
        return $this;
    }
}
