<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerRiskScoreDataOutput StructType
 * @subpackage Structs
 */
class GetCustomerRiskScoreDataOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The CustomerRiskScores
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfCustomerRiskScoreDwData
     */
    public $CustomerRiskScores;
    /**
     * Constructor method for GetCustomerRiskScoreDataOutput
     * @uses GetCustomerRiskScoreDataOutput::setSuccess()
     * @uses GetCustomerRiskScoreDataOutput::setMessage()
     * @uses GetCustomerRiskScoreDataOutput::setCustomerRiskScores()
     * @param bool $success
     * @param string $message
     * @param \CustomerManagement\ArrayType\ArrayOfCustomerRiskScoreDwData $customerRiskScores
     */
    public function __construct($success = null, $message = null, \CustomerManagement\ArrayType\ArrayOfCustomerRiskScoreDwData $customerRiskScores = null)
    {
        $this
            ->setSuccess($success)
            ->setMessage($message)
            ->setCustomerRiskScores($customerRiskScores);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetCustomerRiskScoreDataOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \CustomerManagement\StructType\GetCustomerRiskScoreDataOutput
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get CustomerRiskScores value
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerRiskScoreDwData|null
     */
    public function getCustomerRiskScores()
    {
        return $this->CustomerRiskScores;
    }
    /**
     * Set CustomerRiskScores value
     * @param \CustomerManagement\ArrayType\ArrayOfCustomerRiskScoreDwData $customerRiskScores
     * @return \CustomerManagement\StructType\GetCustomerRiskScoreDataOutput
     */
    public function setCustomerRiskScores(\CustomerManagement\ArrayType\ArrayOfCustomerRiskScoreDwData $customerRiskScores = null)
    {
        $this->CustomerRiskScores = $customerRiskScores;
        return $this;
    }
}
