<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoDeviceWirelessHistory StructType
 * @subpackage Structs
 */
class VideoDeviceWirelessHistory extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The NormalizedWirelessSignalStrength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NormalizedWirelessSignalStrength;
    /**
     * The WirelessSignalStrength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WirelessSignalStrength;
    /**
     * The SignalLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SignalLevel;
    /**
     * The WifiSignalToNoiseRatio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WifiSignalToNoiseRatio;
    /**
     * The MaximumTxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $MaximumTxRate;
    /**
     * Constructor method for VideoDeviceWirelessHistory
     * @uses VideoDeviceWirelessHistory::setDate()
     * @uses VideoDeviceWirelessHistory::setNormalizedWirelessSignalStrength()
     * @uses VideoDeviceWirelessHistory::setWirelessSignalStrength()
     * @uses VideoDeviceWirelessHistory::setSignalLevel()
     * @uses VideoDeviceWirelessHistory::setWifiSignalToNoiseRatio()
     * @uses VideoDeviceWirelessHistory::setMaximumTxRate()
     * @param string $date
     * @param int $normalizedWirelessSignalStrength
     * @param int $wirelessSignalStrength
     * @param int $signalLevel
     * @param int $wifiSignalToNoiseRatio
     * @param int $maximumTxRate
     */
    public function __construct($date = null, $normalizedWirelessSignalStrength = null, $wirelessSignalStrength = null, $signalLevel = null, $wifiSignalToNoiseRatio = null, $maximumTxRate = null)
    {
        $this
            ->setDate($date)
            ->setNormalizedWirelessSignalStrength($normalizedWirelessSignalStrength)
            ->setWirelessSignalStrength($wirelessSignalStrength)
            ->setSignalLevel($signalLevel)
            ->setWifiSignalToNoiseRatio($wifiSignalToNoiseRatio)
            ->setMaximumTxRate($maximumTxRate);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \CustomerManagement\StructType\VideoDeviceWirelessHistory
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get NormalizedWirelessSignalStrength value
     * @return int
     */
    public function getNormalizedWirelessSignalStrength()
    {
        return $this->NormalizedWirelessSignalStrength;
    }
    /**
     * Set NormalizedWirelessSignalStrength value
     * @param int $normalizedWirelessSignalStrength
     * @return \CustomerManagement\StructType\VideoDeviceWirelessHistory
     */
    public function setNormalizedWirelessSignalStrength($normalizedWirelessSignalStrength = null)
    {
        // validation for constraint: int
        if (!is_null($normalizedWirelessSignalStrength) && !(is_int($normalizedWirelessSignalStrength) || ctype_digit($normalizedWirelessSignalStrength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($normalizedWirelessSignalStrength, true), gettype($normalizedWirelessSignalStrength)), __LINE__);
        }
        $this->NormalizedWirelessSignalStrength = $normalizedWirelessSignalStrength;
        return $this;
    }
    /**
     * Get WirelessSignalStrength value
     * @return int
     */
    public function getWirelessSignalStrength()
    {
        return $this->WirelessSignalStrength;
    }
    /**
     * Set WirelessSignalStrength value
     * @param int $wirelessSignalStrength
     * @return \CustomerManagement\StructType\VideoDeviceWirelessHistory
     */
    public function setWirelessSignalStrength($wirelessSignalStrength = null)
    {
        // validation for constraint: int
        if (!is_null($wirelessSignalStrength) && !(is_int($wirelessSignalStrength) || ctype_digit($wirelessSignalStrength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wirelessSignalStrength, true), gettype($wirelessSignalStrength)), __LINE__);
        }
        $this->WirelessSignalStrength = $wirelessSignalStrength;
        return $this;
    }
    /**
     * Get SignalLevel value
     * @return int
     */
    public function getSignalLevel()
    {
        return $this->SignalLevel;
    }
    /**
     * Set SignalLevel value
     * @param int $signalLevel
     * @return \CustomerManagement\StructType\VideoDeviceWirelessHistory
     */
    public function setSignalLevel($signalLevel = null)
    {
        // validation for constraint: int
        if (!is_null($signalLevel) && !(is_int($signalLevel) || ctype_digit($signalLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($signalLevel, true), gettype($signalLevel)), __LINE__);
        }
        $this->SignalLevel = $signalLevel;
        return $this;
    }
    /**
     * Get WifiSignalToNoiseRatio value
     * @return int
     */
    public function getWifiSignalToNoiseRatio()
    {
        return $this->WifiSignalToNoiseRatio;
    }
    /**
     * Set WifiSignalToNoiseRatio value
     * @param int $wifiSignalToNoiseRatio
     * @return \CustomerManagement\StructType\VideoDeviceWirelessHistory
     */
    public function setWifiSignalToNoiseRatio($wifiSignalToNoiseRatio = null)
    {
        // validation for constraint: int
        if (!is_null($wifiSignalToNoiseRatio) && !(is_int($wifiSignalToNoiseRatio) || ctype_digit($wifiSignalToNoiseRatio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wifiSignalToNoiseRatio, true), gettype($wifiSignalToNoiseRatio)), __LINE__);
        }
        $this->WifiSignalToNoiseRatio = $wifiSignalToNoiseRatio;
        return $this;
    }
    /**
     * Get MaximumTxRate value
     * @return int
     */
    public function getMaximumTxRate()
    {
        return $this->MaximumTxRate;
    }
    /**
     * Set MaximumTxRate value
     * @param int $maximumTxRate
     * @return \CustomerManagement\StructType\VideoDeviceWirelessHistory
     */
    public function setMaximumTxRate($maximumTxRate = null)
    {
        // validation for constraint: int
        if (!is_null($maximumTxRate) && !(is_int($maximumTxRate) || ctype_digit($maximumTxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumTxRate, true), gettype($maximumTxRate)), __LINE__);
        }
        $this->MaximumTxRate = $maximumTxRate;
        return $this;
    }
}
