<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDealerCustomerId StructType
 * @subpackage Structs
 */
class UpdateDealerCustomerId extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The dealerCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dealerCustomerId;
    /**
     * Constructor method for UpdateDealerCustomerId
     * @uses UpdateDealerCustomerId::setCustomerId()
     * @uses UpdateDealerCustomerId::setDealerCustomerId()
     * @param int $customerId
     * @param string $dealerCustomerId
     */
    public function __construct($customerId = null, $dealerCustomerId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDealerCustomerId($dealerCustomerId);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateDealerCustomerId
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get dealerCustomerId value
     * @return string|null
     */
    public function getDealerCustomerId()
    {
        return $this->dealerCustomerId;
    }
    /**
     * Set dealerCustomerId value
     * @param string $dealerCustomerId
     * @return \CustomerManagement\StructType\UpdateDealerCustomerId
     */
    public function setDealerCustomerId($dealerCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($dealerCustomerId) && !is_string($dealerCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dealerCustomerId, true), gettype($dealerCustomerId)), __LINE__);
        }
        $this->dealerCustomerId = $dealerCustomerId;
        return $this;
    }
}
