<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for PanelTypeEnum EnumType
 * @subpackage Enumerations
 */
class PanelTypeEnum
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'Concord'
     * @return string 'Concord'
     */
    const VALUE_CONCORD = 'Concord';
    /**
     * Constant for value 'Simon'
     * @return string 'Simon'
     */
    const VALUE_SIMON = 'Simon';
    /**
     * Constant for value 'NX'
     * @return string 'NX'
     */
    const VALUE_NX = 'NX';
    /**
     * Constant for value 'Greybox'
     * @return string 'Greybox'
     */
    const VALUE_GREYBOX = 'Greybox';
    /**
     * Constant for value 'ElkGuard'
     * @return string 'ElkGuard'
     */
    const VALUE_ELK_GUARD = 'ElkGuard';
    /**
     * Constant for value 'TwoG'
     * @return string 'TwoG'
     */
    const VALUE_TWO_G = 'TwoG';
    /**
     * Constant for value 'Touchlink'
     * @return string 'Touchlink'
     */
    const VALUE_TOUCHLINK = 'Touchlink';
    /**
     * Constant for value 'PointHub'
     * @return string 'PointHub'
     */
    const VALUE_POINT_HUB = 'PointHub';
    /**
     * Constant for value 'IQPanel'
     * @return string 'IQPanel'
     */
    const VALUE_IQPANEL = 'IQPanel';
    /**
     * Constant for value 'Building36'
     * @return string 'Building36'
     */
    const VALUE_BUILDING_36 = 'Building36';
    /**
     * Constant for value 'Advisor'
     * @return string 'Advisor'
     */
    const VALUE_ADVISOR = 'Advisor';
    /**
     * Constant for value 'Impassa'
     * @return string 'Impassa'
     */
    const VALUE_IMPASSA = 'Impassa';
    /**
     * Constant for value 'Neo'
     * @return string 'Neo'
     */
    const VALUE_NEO = 'Neo';
    /**
     * Constant for value 'GoControl3'
     * @return string 'GoControl3'
     */
    const VALUE_GO_CONTROL_3 = 'GoControl3';
    /**
     * Constant for value 'Nucleus'
     * @return string 'Nucleus'
     */
    const VALUE_NUCLEUS = 'Nucleus';
    /**
     * Constant for value 'SEMVista'
     * @return string 'SEMVista'
     */
    const VALUE_SEMVISTA = 'SEMVista';
    /**
     * Constant for value 'SEMPowerSeries'
     * @return string 'SEMPowerSeries'
     */
    const VALUE_SEMPOWER_SERIES = 'SEMPowerSeries';
    /**
     * Constant for value 'HxGW'
     * @return string 'HxGW'
     */
    const VALUE_HX_GW = 'HxGW';
    /**
     * Constant for value 'IQPanel2'
     * @return string 'IQPanel2'
     */
    const VALUE_IQPANEL_2 = 'IQPanel2';
    /**
     * Constant for value 'Vario'
     * @return string 'Vario'
     */
    const VALUE_VARIO = 'Vario';
    /**
     * Constant for value 'Iotega'
     * @return string 'Iotega'
     */
    const VALUE_IOTEGA = 'Iotega';
    /**
     * Constant for value 'OneLink'
     * @return string 'OneLink'
     */
    const VALUE_ONE_LINK = 'OneLink';
    /**
     * Constant for value 'Command'
     * @return string 'Command'
     */
    const VALUE_COMMAND = 'Command';
    /**
     * Constant for value 'NoPanel'
     * @return string 'NoPanel'
     */
    const VALUE_NO_PANEL = 'NoPanel';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_CONCORD
     * @uses self::VALUE_SIMON
     * @uses self::VALUE_NX
     * @uses self::VALUE_GREYBOX
     * @uses self::VALUE_ELK_GUARD
     * @uses self::VALUE_TWO_G
     * @uses self::VALUE_TOUCHLINK
     * @uses self::VALUE_POINT_HUB
     * @uses self::VALUE_IQPANEL
     * @uses self::VALUE_BUILDING_36
     * @uses self::VALUE_ADVISOR
     * @uses self::VALUE_IMPASSA
     * @uses self::VALUE_NEO
     * @uses self::VALUE_GO_CONTROL_3
     * @uses self::VALUE_NUCLEUS
     * @uses self::VALUE_SEMVISTA
     * @uses self::VALUE_SEMPOWER_SERIES
     * @uses self::VALUE_HX_GW
     * @uses self::VALUE_IQPANEL_2
     * @uses self::VALUE_VARIO
     * @uses self::VALUE_IOTEGA
     * @uses self::VALUE_ONE_LINK
     * @uses self::VALUE_COMMAND
     * @uses self::VALUE_NO_PANEL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_CONCORD,
            self::VALUE_SIMON,
            self::VALUE_NX,
            self::VALUE_GREYBOX,
            self::VALUE_ELK_GUARD,
            self::VALUE_TWO_G,
            self::VALUE_TOUCHLINK,
            self::VALUE_POINT_HUB,
            self::VALUE_IQPANEL,
            self::VALUE_BUILDING_36,
            self::VALUE_ADVISOR,
            self::VALUE_IMPASSA,
            self::VALUE_NEO,
            self::VALUE_GO_CONTROL_3,
            self::VALUE_NUCLEUS,
            self::VALUE_SEMVISTA,
            self::VALUE_SEMPOWER_SERIES,
            self::VALUE_HX_GW,
            self::VALUE_IQPANEL_2,
            self::VALUE_VARIO,
            self::VALUE_IOTEGA,
            self::VALUE_ONE_LINK,
            self::VALUE_COMMAND,
            self::VALUE_NO_PANEL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
