<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendDeviceGetAssociationsCommandInput StructType
 * @subpackage Structs
 */
class SendDeviceGetAssociationsCommandInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The AssociationGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AssociationGroup;
    /**
     * Constructor method for SendDeviceGetAssociationsCommandInput
     * @uses SendDeviceGetAssociationsCommandInput::setCustomerId()
     * @uses SendDeviceGetAssociationsCommandInput::setDeviceId()
     * @uses SendDeviceGetAssociationsCommandInput::setAssociationGroup()
     * @param int $customerId
     * @param int $deviceId
     * @param int $associationGroup
     */
    public function __construct($customerId = null, $deviceId = null, $associationGroup = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDeviceId($deviceId)
            ->setAssociationGroup($associationGroup);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\SendDeviceGetAssociationsCommandInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\SendDeviceGetAssociationsCommandInput
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get AssociationGroup value
     * @return int
     */
    public function getAssociationGroup()
    {
        return $this->AssociationGroup;
    }
    /**
     * Set AssociationGroup value
     * @param int $associationGroup
     * @return \CustomerManagement\StructType\SendDeviceGetAssociationsCommandInput
     */
    public function setAssociationGroup($associationGroup = null)
    {
        // validation for constraint: int
        if (!is_null($associationGroup) && !(is_int($associationGroup) || ctype_digit($associationGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($associationGroup, true), gettype($associationGroup)), __LINE__);
        }
        $this->AssociationGroup = $associationGroup;
        return $this;
    }
}
