<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RunSystemCheck StructType
 * @subpackage Structs
 */
class RunSystemCheck extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $category;
    /**
     * Constructor method for RunSystemCheck
     * @uses RunSystemCheck::setCustomerId()
     * @uses RunSystemCheck::setCategory()
     * @param int $customerId
     * @param string $category
     */
    public function __construct($customerId = null, $category = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setCategory($category);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\RunSystemCheck
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get category value
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @uses \CustomerManagement\EnumType\SystemCheckTestCategoryEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\SystemCheckTestCategoryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $category
     * @return \CustomerManagement\StructType\RunSystemCheck
     */
    public function setCategory($category = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\SystemCheckTestCategoryEnum::valueIsValid($category)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $category, implode(', ', \CustomerManagement\EnumType\SystemCheckTestCategoryEnum::getValidValues())), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\RunSystemCheck
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
