<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for GsmRegistrationStateEnum EnumType
 * @subpackage Enumerations
 */
class GsmRegistrationStateEnum
{
    /**
     * Constant for value 'NotRegisteredIdle'
     * @return string 'NotRegisteredIdle'
     */
    const VALUE_NOT_REGISTERED_IDLE = 'NotRegisteredIdle';
    /**
     * Constant for value 'InNetwork'
     * @return string 'InNetwork'
     */
    const VALUE_IN_NETWORK = 'InNetwork';
    /**
     * Constant for value 'NotRegisteredTrying'
     * @return string 'NotRegisteredTrying'
     */
    const VALUE_NOT_REGISTERED_TRYING = 'NotRegisteredTrying';
    /**
     * Constant for value 'NotRegisteredNotActive'
     * @return string 'NotRegisteredNotActive'
     */
    const VALUE_NOT_REGISTERED_NOT_ACTIVE = 'NotRegisteredNotActive';
    /**
     * Constant for value 'Roaming'
     * @return string 'Roaming'
     */
    const VALUE_ROAMING = 'Roaming';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_REGISTERED_IDLE
     * @uses self::VALUE_IN_NETWORK
     * @uses self::VALUE_NOT_REGISTERED_TRYING
     * @uses self::VALUE_NOT_REGISTERED_NOT_ACTIVE
     * @uses self::VALUE_ROAMING
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_REGISTERED_IDLE,
            self::VALUE_IN_NETWORK,
            self::VALUE_NOT_REGISTERED_TRYING,
            self::VALUE_NOT_REGISTERED_NOT_ACTIVE,
            self::VALUE_ROAMING,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
