<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServicePlanInfo StructType
 * @subpackage Structs
 */
class ServicePlanInfo extends AbstractStructBase
{
    /**
     * The PackageId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PackageId;
    /**
     * The PlanType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PlanType;
    /**
     * The TotalServicePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalServicePrice;
    /**
     * The AddonsFilteredDueToCallerVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AddonsFilteredDueToCallerVersion;
    /**
     * The Addons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum
     */
    public $Addons;
    /**
     * The PackageDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PackageDescription;
    /**
     * Constructor method for ServicePlanInfo
     * @uses ServicePlanInfo::setPackageId()
     * @uses ServicePlanInfo::setPlanType()
     * @uses ServicePlanInfo::setTotalServicePrice()
     * @uses ServicePlanInfo::setAddonsFilteredDueToCallerVersion()
     * @uses ServicePlanInfo::setAddons()
     * @uses ServicePlanInfo::setPackageDescription()
     * @param int $packageId
     * @param string $planType
     * @param float $totalServicePrice
     * @param bool $addonsFilteredDueToCallerVersion
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addons
     * @param string $packageDescription
     */
    public function __construct($packageId = null, $planType = null, $totalServicePrice = null, $addonsFilteredDueToCallerVersion = null, \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addons = null, $packageDescription = null)
    {
        $this
            ->setPackageId($packageId)
            ->setPlanType($planType)
            ->setTotalServicePrice($totalServicePrice)
            ->setAddonsFilteredDueToCallerVersion($addonsFilteredDueToCallerVersion)
            ->setAddons($addons)
            ->setPackageDescription($packageDescription);
    }
    /**
     * Get PackageId value
     * @return int
     */
    public function getPackageId()
    {
        return $this->PackageId;
    }
    /**
     * Set PackageId value
     * @param int $packageId
     * @return \CustomerManagement\StructType\ServicePlanInfo
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: int
        if (!is_null($packageId) && !is_numeric($packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageId)), __LINE__);
        }
        $this->PackageId = $packageId;
        return $this;
    }
    /**
     * Get PlanType value
     * @return string
     */
    public function getPlanType()
    {
        return $this->PlanType;
    }
    /**
     * Set PlanType value
     * @uses \CustomerManagement\EnumType\PackageGroupEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PackageGroupEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $planType
     * @return \CustomerManagement\StructType\ServicePlanInfo
     */
    public function setPlanType($planType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PackageGroupEnum::valueIsValid($planType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $planType, implode(', ', \CustomerManagement\EnumType\PackageGroupEnum::getValidValues())), __LINE__);
        }
        $this->PlanType = $planType;
        return $this;
    }
    /**
     * Get TotalServicePrice value
     * @return float
     */
    public function getTotalServicePrice()
    {
        return $this->TotalServicePrice;
    }
    /**
     * Set TotalServicePrice value
     * @param float $totalServicePrice
     * @return \CustomerManagement\StructType\ServicePlanInfo
     */
    public function setTotalServicePrice($totalServicePrice = null)
    {
        $this->TotalServicePrice = $totalServicePrice;
        return $this;
    }
    /**
     * Get AddonsFilteredDueToCallerVersion value
     * @return bool
     */
    public function getAddonsFilteredDueToCallerVersion()
    {
        return $this->AddonsFilteredDueToCallerVersion;
    }
    /**
     * Set AddonsFilteredDueToCallerVersion value
     * @param bool $addonsFilteredDueToCallerVersion
     * @return \CustomerManagement\StructType\ServicePlanInfo
     */
    public function setAddonsFilteredDueToCallerVersion($addonsFilteredDueToCallerVersion = null)
    {
        // validation for constraint: boolean
        if (!is_null($addonsFilteredDueToCallerVersion) && !is_bool($addonsFilteredDueToCallerVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($addonsFilteredDueToCallerVersion)), __LINE__);
        }
        $this->AddonsFilteredDueToCallerVersion = $addonsFilteredDueToCallerVersion;
        return $this;
    }
    /**
     * Get Addons value
     * @return \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum|null
     */
    public function getAddons()
    {
        return $this->Addons;
    }
    /**
     * Set Addons value
     * @param \CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addons
     * @return \CustomerManagement\StructType\ServicePlanInfo
     */
    public function setAddons(\CustomerManagement\ArrayType\ArrayOfAddOnFeatureEnum $addons = null)
    {
        $this->Addons = $addons;
        return $this;
    }
    /**
     * Get PackageDescription value
     * @return string|null
     */
    public function getPackageDescription()
    {
        return $this->PackageDescription;
    }
    /**
     * Set PackageDescription value
     * @param string $packageDescription
     * @return \CustomerManagement\StructType\ServicePlanInfo
     */
    public function setPackageDescription($packageDescription = null)
    {
        // validation for constraint: string
        if (!is_null($packageDescription) && !is_string($packageDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageDescription)), __LINE__);
        }
        $this->PackageDescription = $packageDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\ServicePlanInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
