<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPermissions StructType
 * @subpackage Structs
 */
class CustomerPermissions extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The Roles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt
     */
    public $Roles;
    /**
     * Constructor method for CustomerPermissions
     * @uses CustomerPermissions::setCustomerId()
     * @uses CustomerPermissions::setRoles()
     * @param int $customerId
     * @param \CustomerManagement\ArrayType\ArrayOfInt $roles
     */
    public function __construct($customerId = null, \CustomerManagement\ArrayType\ArrayOfInt $roles = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setRoles($roles);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\CustomerPermissions
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get Roles value
     * @return \CustomerManagement\ArrayType\ArrayOfInt|null
     */
    public function getRoles()
    {
        return $this->Roles;
    }
    /**
     * Set Roles value
     * @param \CustomerManagement\ArrayType\ArrayOfInt $roles
     * @return \CustomerManagement\StructType\CustomerPermissions
     */
    public function setRoles(\CustomerManagement\ArrayType\ArrayOfInt $roles = null)
    {
        $this->Roles = $roles;
        return $this;
    }
}
