<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateNewCustomerWebsiteMessageInput StructType
 * @subpackage Structs
 */
class CreateNewCustomerWebsiteMessageInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The LoginId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LoginId;
    /**
     * The PermissionToView
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PermissionToView;
    /**
     * The PermissionValueToView
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PermissionValueToView;
    /**
     * The PermissionToClear
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PermissionToClear;
    /**
     * The PermissionValueToClear
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PermissionValueToClear;
    /**
     * The MessageId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MessageId;
    /**
     * The StartDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDateUtc;
    /**
     * The ValidUntilDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ValidUntilDateUtc;
    /**
     * The ClearingOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ClearingOption;
    /**
     * The Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfString
     */
    public $Parameters;
    /**
     * Constructor method for CreateNewCustomerWebsiteMessageInput
     * @uses CreateNewCustomerWebsiteMessageInput::setCustomerId()
     * @uses CreateNewCustomerWebsiteMessageInput::setLoginId()
     * @uses CreateNewCustomerWebsiteMessageInput::setPermissionToView()
     * @uses CreateNewCustomerWebsiteMessageInput::setPermissionValueToView()
     * @uses CreateNewCustomerWebsiteMessageInput::setPermissionToClear()
     * @uses CreateNewCustomerWebsiteMessageInput::setPermissionValueToClear()
     * @uses CreateNewCustomerWebsiteMessageInput::setMessageId()
     * @uses CreateNewCustomerWebsiteMessageInput::setStartDateUtc()
     * @uses CreateNewCustomerWebsiteMessageInput::setValidUntilDateUtc()
     * @uses CreateNewCustomerWebsiteMessageInput::setClearingOption()
     * @uses CreateNewCustomerWebsiteMessageInput::setParameters()
     * @param int $customerId
     * @param int $loginId
     * @param string $permissionToView
     * @param string $permissionValueToView
     * @param string $permissionToClear
     * @param string $permissionValueToClear
     * @param int $messageId
     * @param string $startDateUtc
     * @param string $validUntilDateUtc
     * @param string $clearingOption
     * @param \CustomerManagement\ArrayType\ArrayOfString $parameters
     */
    public function __construct($customerId = null, $loginId = null, $permissionToView = null, $permissionValueToView = null, $permissionToClear = null, $permissionValueToClear = null, $messageId = null, $startDateUtc = null, $validUntilDateUtc = null, $clearingOption = null, \CustomerManagement\ArrayType\ArrayOfString $parameters = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setLoginId($loginId)
            ->setPermissionToView($permissionToView)
            ->setPermissionValueToView($permissionValueToView)
            ->setPermissionToClear($permissionToClear)
            ->setPermissionValueToClear($permissionValueToClear)
            ->setMessageId($messageId)
            ->setStartDateUtc($startDateUtc)
            ->setValidUntilDateUtc($validUntilDateUtc)
            ->setClearingOption($clearingOption)
            ->setParameters($parameters);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\CreateNewCustomerWebsiteMessageInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get LoginId value
     * @return int
     */
    public function getLoginId()
    {
        return $this->LoginId;
    }
    /**
     * Set LoginId value
     * @param int $loginId
     * @return \CustomerManagement\StructType\CreateNewCustomerWebsiteMessageInput
     */
    public function setLoginId($loginId = null)
    {
        // validation for constraint: int
        if (!is_null($loginId) && !(is_int($loginId) || ctype_digit($loginId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loginId, true), gettype($loginId)), __LINE__);
        }
        $this->LoginId = $loginId;
        return $this;
    }
    /**
     * Get PermissionToView value
     * @return string
     */
    public function getPermissionToView()
    {
        return $this->PermissionToView;
    }
    /**
     * Set PermissionToView value
     * @uses \CustomerManagement\EnumType\MessagePermissionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\MessagePermissionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $permissionToView
     * @return \CustomerManagement\StructType\CreateNewCustomerWebsiteMessageInput
     */
    public function setPermissionToView($permissionToView = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\MessagePermissionEnum::valueIsValid($permissionToView)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\MessagePermissionEnum', is_array($permissionToView) ? implode(', ', $permissionToView) : var_export($permissionToView, true), implode(', ', \CustomerManagement\EnumType\MessagePermissionEnum::getValidValues())), __LINE__);
        }
        $this->PermissionToView = $permissionToView;
        return $this;
    }
    /**
     * Get PermissionValueToView value
     * @return string
     */
    public function getPermissionValueToView()
    {
        return $this->PermissionValueToView;
    }
    /**
     * Set PermissionValueToView value
     * @uses \CustomerManagement\EnumType\MessagePermissionLevelEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\MessagePermissionLevelEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $permissionValueToView
     * @return \CustomerManagement\StructType\CreateNewCustomerWebsiteMessageInput
     */
    public function setPermissionValueToView($permissionValueToView = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\MessagePermissionLevelEnum::valueIsValid($permissionValueToView)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\MessagePermissionLevelEnum', is_array($permissionValueToView) ? implode(', ', $permissionValueToView) : var_export($permissionValueToView, true), implode(', ', \CustomerManagement\EnumType\MessagePermissionLevelEnum::getValidValues())), __LINE__);
        }
        $this->PermissionValueToView = $permissionValueToView;
        return $this;
    }
    /**
     * Get PermissionToClear value
     * @return string
     */
    public function getPermissionToClear()
    {
        return $this->PermissionToClear;
    }
    /**
     * Set PermissionToClear value
     * @uses \CustomerManagement\EnumType\MessagePermissionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\MessagePermissionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $permissionToClear
     * @return \CustomerManagement\StructType\CreateNewCustomerWebsiteMessageInput
     */
    public function setPermissionToClear($permissionToClear = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\MessagePermissionEnum::valueIsValid($permissionToClear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\MessagePermissionEnum', is_array($permissionToClear) ? implode(', ', $permissionToClear) : var_export($permissionToClear, true), implode(', ', \CustomerManagement\EnumType\MessagePermissionEnum::getValidValues())), __LINE__);
        }
        $this->PermissionToClear = $permissionToClear;
        return $this;
    }
    /**
     * Get PermissionValueToClear value
     * @return string
     */
    public function getPermissionValueToClear()
    {
        return $this->PermissionValueToClear;
    }
    /**
     * Set PermissionValueToClear value
     * @uses \CustomerManagement\EnumType\MessagePermissionLevelEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\MessagePermissionLevelEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $permissionValueToClear
     * @return \CustomerManagement\StructType\CreateNewCustomerWebsiteMessageInput
     */
    public function setPermissionValueToClear($permissionValueToClear = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\MessagePermissionLevelEnum::valueIsValid($permissionValueToClear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\MessagePermissionLevelEnum', is_array($permissionValueToClear) ? implode(', ', $permissionValueToClear) : var_export($permissionValueToClear, true), implode(', ', \CustomerManagement\EnumType\MessagePermissionLevelEnum::getValidValues())), __LINE__);
        }
        $this->PermissionValueToClear = $permissionValueToClear;
        return $this;
    }
    /**
     * Get MessageId value
     * @return int
     */
    public function getMessageId()
    {
        return $this->MessageId;
    }
    /**
     * Set MessageId value
     * @param int $messageId
     * @return \CustomerManagement\StructType\CreateNewCustomerWebsiteMessageInput
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: int
        if (!is_null($messageId) && !(is_int($messageId) || ctype_digit($messageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($messageId, true), gettype($messageId)), __LINE__);
        }
        $this->MessageId = $messageId;
        return $this;
    }
    /**
     * Get StartDateUtc value
     * @return string
     */
    public function getStartDateUtc()
    {
        return $this->StartDateUtc;
    }
    /**
     * Set StartDateUtc value
     * @param string $startDateUtc
     * @return \CustomerManagement\StructType\CreateNewCustomerWebsiteMessageInput
     */
    public function setStartDateUtc($startDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($startDateUtc) && !is_string($startDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateUtc, true), gettype($startDateUtc)), __LINE__);
        }
        $this->StartDateUtc = $startDateUtc;
        return $this;
    }
    /**
     * Get ValidUntilDateUtc value
     * @return string
     */
    public function getValidUntilDateUtc()
    {
        return $this->ValidUntilDateUtc;
    }
    /**
     * Set ValidUntilDateUtc value
     * @param string $validUntilDateUtc
     * @return \CustomerManagement\StructType\CreateNewCustomerWebsiteMessageInput
     */
    public function setValidUntilDateUtc($validUntilDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($validUntilDateUtc) && !is_string($validUntilDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validUntilDateUtc, true), gettype($validUntilDateUtc)), __LINE__);
        }
        $this->ValidUntilDateUtc = $validUntilDateUtc;
        return $this;
    }
    /**
     * Get ClearingOption value
     * @return string
     */
    public function getClearingOption()
    {
        return $this->ClearingOption;
    }
    /**
     * Set ClearingOption value
     * @uses \CustomerManagement\EnumType\WebsiteMessageClearingOptionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\WebsiteMessageClearingOptionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clearingOption
     * @return \CustomerManagement\StructType\CreateNewCustomerWebsiteMessageInput
     */
    public function setClearingOption($clearingOption = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\WebsiteMessageClearingOptionEnum::valueIsValid($clearingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\WebsiteMessageClearingOptionEnum', is_array($clearingOption) ? implode(', ', $clearingOption) : var_export($clearingOption, true), implode(', ', \CustomerManagement\EnumType\WebsiteMessageClearingOptionEnum::getValidValues())), __LINE__);
        }
        $this->ClearingOption = $clearingOption;
        return $this;
    }
    /**
     * Get Parameters value
     * @return \CustomerManagement\ArrayType\ArrayOfString|null
     */
    public function getParameters()
    {
        return $this->Parameters;
    }
    /**
     * Set Parameters value
     * @param \CustomerManagement\ArrayType\ArrayOfString $parameters
     * @return \CustomerManagement\StructType\CreateNewCustomerWebsiteMessageInput
     */
    public function setParameters(\CustomerManagement\ArrayType\ArrayOfString $parameters = null)
    {
        $this->Parameters = $parameters;
        return $this;
    }
}
