<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TurnOffAccessCodeLock StructType
 * @subpackage Structs
 */
class TurnOffAccessCodeLock extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The installerCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $installerCode;
    /**
     * Constructor method for TurnOffAccessCodeLock
     * @uses TurnOffAccessCodeLock::setCustomerId()
     * @uses TurnOffAccessCodeLock::setInstallerCode()
     * @param int $customerId
     * @param string $installerCode
     */
    public function __construct($customerId = null, $installerCode = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setInstallerCode($installerCode);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\TurnOffAccessCodeLock
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get installerCode value
     * @return string|null
     */
    public function getInstallerCode()
    {
        return $this->installerCode;
    }
    /**
     * Set installerCode value
     * @param string $installerCode
     * @return \CustomerManagement\StructType\TurnOffAccessCodeLock
     */
    public function setInstallerCode($installerCode = null)
    {
        // validation for constraint: string
        if (!is_null($installerCode) && !is_string($installerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($installerCode)), __LINE__);
        }
        $this->installerCode = $installerCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\TurnOffAccessCodeLock
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
