<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PanelLockoutInput StructType
 * @subpackage Structs
 */
class PanelLockoutInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The NewMasterCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewMasterCode;
    /**
     * Constructor method for PanelLockoutInput
     * @uses PanelLockoutInput::setCustomerId()
     * @uses PanelLockoutInput::setNewMasterCode()
     * @param int $customerId
     * @param string $newMasterCode
     */
    public function __construct($customerId = null, $newMasterCode = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setNewMasterCode($newMasterCode);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\PanelLockoutInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get NewMasterCode value
     * @return string|null
     */
    public function getNewMasterCode()
    {
        return $this->NewMasterCode;
    }
    /**
     * Set NewMasterCode value
     * @param string $newMasterCode
     * @return \CustomerManagement\StructType\PanelLockoutInput
     */
    public function setNewMasterCode($newMasterCode = null)
    {
        // validation for constraint: string
        if (!is_null($newMasterCode) && !is_string($newMasterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newMasterCode, true), gettype($newMasterCode)), __LINE__);
        }
        $this->NewMasterCode = $newMasterCode;
        return $this;
    }
}
