<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAdvancedWifiStatsForVideoDeviceInput StructType
 * @subpackage Structs
 */
class GetAdvancedWifiStatsForVideoDeviceInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * Constructor method for GetAdvancedWifiStatsForVideoDeviceInput
     * @uses GetAdvancedWifiStatsForVideoDeviceInput::setCustomerId()
     * @uses GetAdvancedWifiStatsForVideoDeviceInput::setDeviceId()
     * @param int $customerId
     * @param int $deviceId
     */
    public function __construct($customerId = null, $deviceId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDeviceId($deviceId);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\GetAdvancedWifiStatsForVideoDeviceInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\GetAdvancedWifiStatsForVideoDeviceInput
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
}
