<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteZWaveDeviceInput StructType
 * @subpackage Structs
 */
class DeleteZWaveDeviceInput extends AbstractStructBase
{
    /**
     * The NodeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NodeId;
    /**
     * The GatewayDeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GatewayDeviceId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * Constructor method for DeleteZWaveDeviceInput
     * @uses DeleteZWaveDeviceInput::setNodeId()
     * @uses DeleteZWaveDeviceInput::setGatewayDeviceId()
     * @uses DeleteZWaveDeviceInput::setCustomerId()
     * @param int $nodeId
     * @param int $gatewayDeviceId
     * @param int $customerId
     */
    public function __construct($nodeId = null, $gatewayDeviceId = null, $customerId = null)
    {
        $this
            ->setNodeId($nodeId)
            ->setGatewayDeviceId($gatewayDeviceId)
            ->setCustomerId($customerId);
    }
    /**
     * Get NodeId value
     * @return int
     */
    public function getNodeId()
    {
        return $this->NodeId;
    }
    /**
     * Set NodeId value
     * @param int $nodeId
     * @return \CustomerManagement\StructType\DeleteZWaveDeviceInput
     */
    public function setNodeId($nodeId = null)
    {
        // validation for constraint: int
        if (!is_null($nodeId) && !(is_int($nodeId) || ctype_digit($nodeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nodeId, true), gettype($nodeId)), __LINE__);
        }
        $this->NodeId = $nodeId;
        return $this;
    }
    /**
     * Get GatewayDeviceId value
     * @return int
     */
    public function getGatewayDeviceId()
    {
        return $this->GatewayDeviceId;
    }
    /**
     * Set GatewayDeviceId value
     * @param int $gatewayDeviceId
     * @return \CustomerManagement\StructType\DeleteZWaveDeviceInput
     */
    public function setGatewayDeviceId($gatewayDeviceId = null)
    {
        // validation for constraint: int
        if (!is_null($gatewayDeviceId) && !(is_int($gatewayDeviceId) || ctype_digit($gatewayDeviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gatewayDeviceId, true), gettype($gatewayDeviceId)), __LINE__);
        }
        $this->GatewayDeviceId = $gatewayDeviceId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\DeleteZWaveDeviceInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
}
