<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddOnHistoryItem StructType
 * @subpackage Structs
 */
class AddOnHistoryItem extends AbstractStructBase
{
    /**
     * The ChangeDateUtc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ChangeDateUtc;
    /**
     * The ChangeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChangeType;
    /**
     * The ServicePlanFeatureDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServicePlanFeatureDescription;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Quantity;
    /**
     * Constructor method for AddOnHistoryItem
     * @uses AddOnHistoryItem::setChangeDateUtc()
     * @uses AddOnHistoryItem::setChangeType()
     * @uses AddOnHistoryItem::setServicePlanFeatureDescription()
     * @uses AddOnHistoryItem::setQuantity()
     * @param string $changeDateUtc
     * @param string $changeType
     * @param string $servicePlanFeatureDescription
     * @param string $quantity
     */
    public function __construct($changeDateUtc = null, $changeType = null, $servicePlanFeatureDescription = null, $quantity = null)
    {
        $this
            ->setChangeDateUtc($changeDateUtc)
            ->setChangeType($changeType)
            ->setServicePlanFeatureDescription($servicePlanFeatureDescription)
            ->setQuantity($quantity);
    }
    /**
     * Get ChangeDateUtc value
     * @return string
     */
    public function getChangeDateUtc()
    {
        return $this->ChangeDateUtc;
    }
    /**
     * Set ChangeDateUtc value
     * @param string $changeDateUtc
     * @return \CustomerManagement\StructType\AddOnHistoryItem
     */
    public function setChangeDateUtc($changeDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($changeDateUtc) && !is_string($changeDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($changeDateUtc)), __LINE__);
        }
        $this->ChangeDateUtc = $changeDateUtc;
        return $this;
    }
    /**
     * Get ChangeType value
     * @return string|null
     */
    public function getChangeType()
    {
        return $this->ChangeType;
    }
    /**
     * Set ChangeType value
     * @param string $changeType
     * @return \CustomerManagement\StructType\AddOnHistoryItem
     */
    public function setChangeType($changeType = null)
    {
        // validation for constraint: string
        if (!is_null($changeType) && !is_string($changeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($changeType)), __LINE__);
        }
        $this->ChangeType = $changeType;
        return $this;
    }
    /**
     * Get ServicePlanFeatureDescription value
     * @return string|null
     */
    public function getServicePlanFeatureDescription()
    {
        return $this->ServicePlanFeatureDescription;
    }
    /**
     * Set ServicePlanFeatureDescription value
     * @param string $servicePlanFeatureDescription
     * @return \CustomerManagement\StructType\AddOnHistoryItem
     */
    public function setServicePlanFeatureDescription($servicePlanFeatureDescription = null)
    {
        // validation for constraint: string
        if (!is_null($servicePlanFeatureDescription) && !is_string($servicePlanFeatureDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePlanFeatureDescription)), __LINE__);
        }
        $this->ServicePlanFeatureDescription = $servicePlanFeatureDescription;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \CustomerManagement\StructType\AddOnHistoryItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\AddOnHistoryItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
