<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoDeviceInformation StructType
 * @subpackage Structs
 */
class VideoDeviceInformation extends AbstractStructBase
{
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The FrequencyBand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $FrequencyBand;
    /**
     * The LastVideoUpload
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastVideoUpload;
    /**
     * The LastSuccessfulSupervision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastSuccessfulSupervision;
    /**
     * The LastFailedSupervision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastFailedSupervision;
    /**
     * The TotalStoredClips
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalStoredClips;
    /**
     * The WebsiteDeviceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WebsiteDeviceName;
    /**
     * The VideoDeviceModel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VideoDeviceModel;
    /**
     * The FirmwareVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirmwareVersion;
    /**
     * The CurrentNetworkSSID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrentNetworkSSID;
    /**
     * The NormalizedWirelessSignalStrength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NormalizedWirelessSignalStrength;
    /**
     * The WirelessEncryptionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WirelessEncryptionType;
    /**
     * The ActiveTroubleConditions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfString
     */
    public $ActiveTroubleConditions;
    /**
     * Constructor method for VideoDeviceInformation
     * @uses VideoDeviceInformation::setDeviceId()
     * @uses VideoDeviceInformation::setFrequencyBand()
     * @uses VideoDeviceInformation::setLastVideoUpload()
     * @uses VideoDeviceInformation::setLastSuccessfulSupervision()
     * @uses VideoDeviceInformation::setLastFailedSupervision()
     * @uses VideoDeviceInformation::setTotalStoredClips()
     * @uses VideoDeviceInformation::setWebsiteDeviceName()
     * @uses VideoDeviceInformation::setVideoDeviceModel()
     * @uses VideoDeviceInformation::setFirmwareVersion()
     * @uses VideoDeviceInformation::setCurrentNetworkSSID()
     * @uses VideoDeviceInformation::setNormalizedWirelessSignalStrength()
     * @uses VideoDeviceInformation::setWirelessEncryptionType()
     * @uses VideoDeviceInformation::setActiveTroubleConditions()
     * @param int $deviceId
     * @param float $frequencyBand
     * @param string $lastVideoUpload
     * @param string $lastSuccessfulSupervision
     * @param string $lastFailedSupervision
     * @param float $totalStoredClips
     * @param string $websiteDeviceName
     * @param string $videoDeviceModel
     * @param string $firmwareVersion
     * @param string $currentNetworkSSID
     * @param string $normalizedWirelessSignalStrength
     * @param string $wirelessEncryptionType
     * @param \CustomerManagement\ArrayType\ArrayOfString $activeTroubleConditions
     */
    public function __construct($deviceId = null, $frequencyBand = null, $lastVideoUpload = null, $lastSuccessfulSupervision = null, $lastFailedSupervision = null, $totalStoredClips = null, $websiteDeviceName = null, $videoDeviceModel = null, $firmwareVersion = null, $currentNetworkSSID = null, $normalizedWirelessSignalStrength = null, $wirelessEncryptionType = null, \CustomerManagement\ArrayType\ArrayOfString $activeTroubleConditions = null)
    {
        $this
            ->setDeviceId($deviceId)
            ->setFrequencyBand($frequencyBand)
            ->setLastVideoUpload($lastVideoUpload)
            ->setLastSuccessfulSupervision($lastSuccessfulSupervision)
            ->setLastFailedSupervision($lastFailedSupervision)
            ->setTotalStoredClips($totalStoredClips)
            ->setWebsiteDeviceName($websiteDeviceName)
            ->setVideoDeviceModel($videoDeviceModel)
            ->setFirmwareVersion($firmwareVersion)
            ->setCurrentNetworkSSID($currentNetworkSSID)
            ->setNormalizedWirelessSignalStrength($normalizedWirelessSignalStrength)
            ->setWirelessEncryptionType($wirelessEncryptionType)
            ->setActiveTroubleConditions($activeTroubleConditions);
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\VideoDeviceInformation
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get FrequencyBand value
     * @return float
     */
    public function getFrequencyBand()
    {
        return $this->FrequencyBand;
    }
    /**
     * Set FrequencyBand value
     * @param float $frequencyBand
     * @return \CustomerManagement\StructType\VideoDeviceInformation
     */
    public function setFrequencyBand($frequencyBand = null)
    {
        // validation for constraint: float
        if (!is_null($frequencyBand) && !(is_float($frequencyBand) || is_numeric($frequencyBand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($frequencyBand, true), gettype($frequencyBand)), __LINE__);
        }
        $this->FrequencyBand = $frequencyBand;
        return $this;
    }
    /**
     * Get LastVideoUpload value
     * @return string
     */
    public function getLastVideoUpload()
    {
        return $this->LastVideoUpload;
    }
    /**
     * Set LastVideoUpload value
     * @param string $lastVideoUpload
     * @return \CustomerManagement\StructType\VideoDeviceInformation
     */
    public function setLastVideoUpload($lastVideoUpload = null)
    {
        // validation for constraint: string
        if (!is_null($lastVideoUpload) && !is_string($lastVideoUpload)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastVideoUpload, true), gettype($lastVideoUpload)), __LINE__);
        }
        $this->LastVideoUpload = $lastVideoUpload;
        return $this;
    }
    /**
     * Get LastSuccessfulSupervision value
     * @return string
     */
    public function getLastSuccessfulSupervision()
    {
        return $this->LastSuccessfulSupervision;
    }
    /**
     * Set LastSuccessfulSupervision value
     * @param string $lastSuccessfulSupervision
     * @return \CustomerManagement\StructType\VideoDeviceInformation
     */
    public function setLastSuccessfulSupervision($lastSuccessfulSupervision = null)
    {
        // validation for constraint: string
        if (!is_null($lastSuccessfulSupervision) && !is_string($lastSuccessfulSupervision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastSuccessfulSupervision, true), gettype($lastSuccessfulSupervision)), __LINE__);
        }
        $this->LastSuccessfulSupervision = $lastSuccessfulSupervision;
        return $this;
    }
    /**
     * Get LastFailedSupervision value
     * @return string
     */
    public function getLastFailedSupervision()
    {
        return $this->LastFailedSupervision;
    }
    /**
     * Set LastFailedSupervision value
     * @param string $lastFailedSupervision
     * @return \CustomerManagement\StructType\VideoDeviceInformation
     */
    public function setLastFailedSupervision($lastFailedSupervision = null)
    {
        // validation for constraint: string
        if (!is_null($lastFailedSupervision) && !is_string($lastFailedSupervision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastFailedSupervision, true), gettype($lastFailedSupervision)), __LINE__);
        }
        $this->LastFailedSupervision = $lastFailedSupervision;
        return $this;
    }
    /**
     * Get TotalStoredClips value
     * @return float
     */
    public function getTotalStoredClips()
    {
        return $this->TotalStoredClips;
    }
    /**
     * Set TotalStoredClips value
     * @param float $totalStoredClips
     * @return \CustomerManagement\StructType\VideoDeviceInformation
     */
    public function setTotalStoredClips($totalStoredClips = null)
    {
        // validation for constraint: float
        if (!is_null($totalStoredClips) && !(is_float($totalStoredClips) || is_numeric($totalStoredClips))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalStoredClips, true), gettype($totalStoredClips)), __LINE__);
        }
        $this->TotalStoredClips = $totalStoredClips;
        return $this;
    }
    /**
     * Get WebsiteDeviceName value
     * @return string|null
     */
    public function getWebsiteDeviceName()
    {
        return $this->WebsiteDeviceName;
    }
    /**
     * Set WebsiteDeviceName value
     * @param string $websiteDeviceName
     * @return \CustomerManagement\StructType\VideoDeviceInformation
     */
    public function setWebsiteDeviceName($websiteDeviceName = null)
    {
        // validation for constraint: string
        if (!is_null($websiteDeviceName) && !is_string($websiteDeviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($websiteDeviceName, true), gettype($websiteDeviceName)), __LINE__);
        }
        $this->WebsiteDeviceName = $websiteDeviceName;
        return $this;
    }
    /**
     * Get VideoDeviceModel value
     * @return string|null
     */
    public function getVideoDeviceModel()
    {
        return $this->VideoDeviceModel;
    }
    /**
     * Set VideoDeviceModel value
     * @param string $videoDeviceModel
     * @return \CustomerManagement\StructType\VideoDeviceInformation
     */
    public function setVideoDeviceModel($videoDeviceModel = null)
    {
        // validation for constraint: string
        if (!is_null($videoDeviceModel) && !is_string($videoDeviceModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($videoDeviceModel, true), gettype($videoDeviceModel)), __LINE__);
        }
        $this->VideoDeviceModel = $videoDeviceModel;
        return $this;
    }
    /**
     * Get FirmwareVersion value
     * @return string|null
     */
    public function getFirmwareVersion()
    {
        return $this->FirmwareVersion;
    }
    /**
     * Set FirmwareVersion value
     * @param string $firmwareVersion
     * @return \CustomerManagement\StructType\VideoDeviceInformation
     */
    public function setFirmwareVersion($firmwareVersion = null)
    {
        // validation for constraint: string
        if (!is_null($firmwareVersion) && !is_string($firmwareVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firmwareVersion, true), gettype($firmwareVersion)), __LINE__);
        }
        $this->FirmwareVersion = $firmwareVersion;
        return $this;
    }
    /**
     * Get CurrentNetworkSSID value
     * @return string|null
     */
    public function getCurrentNetworkSSID()
    {
        return $this->CurrentNetworkSSID;
    }
    /**
     * Set CurrentNetworkSSID value
     * @param string $currentNetworkSSID
     * @return \CustomerManagement\StructType\VideoDeviceInformation
     */
    public function setCurrentNetworkSSID($currentNetworkSSID = null)
    {
        // validation for constraint: string
        if (!is_null($currentNetworkSSID) && !is_string($currentNetworkSSID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentNetworkSSID, true), gettype($currentNetworkSSID)), __LINE__);
        }
        $this->CurrentNetworkSSID = $currentNetworkSSID;
        return $this;
    }
    /**
     * Get NormalizedWirelessSignalStrength value
     * @return string|null
     */
    public function getNormalizedWirelessSignalStrength()
    {
        return $this->NormalizedWirelessSignalStrength;
    }
    /**
     * Set NormalizedWirelessSignalStrength value
     * @param string $normalizedWirelessSignalStrength
     * @return \CustomerManagement\StructType\VideoDeviceInformation
     */
    public function setNormalizedWirelessSignalStrength($normalizedWirelessSignalStrength = null)
    {
        // validation for constraint: string
        if (!is_null($normalizedWirelessSignalStrength) && !is_string($normalizedWirelessSignalStrength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalizedWirelessSignalStrength, true), gettype($normalizedWirelessSignalStrength)), __LINE__);
        }
        $this->NormalizedWirelessSignalStrength = $normalizedWirelessSignalStrength;
        return $this;
    }
    /**
     * Get WirelessEncryptionType value
     * @return string|null
     */
    public function getWirelessEncryptionType()
    {
        return $this->WirelessEncryptionType;
    }
    /**
     * Set WirelessEncryptionType value
     * @param string $wirelessEncryptionType
     * @return \CustomerManagement\StructType\VideoDeviceInformation
     */
    public function setWirelessEncryptionType($wirelessEncryptionType = null)
    {
        // validation for constraint: string
        if (!is_null($wirelessEncryptionType) && !is_string($wirelessEncryptionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wirelessEncryptionType, true), gettype($wirelessEncryptionType)), __LINE__);
        }
        $this->WirelessEncryptionType = $wirelessEncryptionType;
        return $this;
    }
    /**
     * Get ActiveTroubleConditions value
     * @return \CustomerManagement\ArrayType\ArrayOfString|null
     */
    public function getActiveTroubleConditions()
    {
        return $this->ActiveTroubleConditions;
    }
    /**
     * Set ActiveTroubleConditions value
     * @param \CustomerManagement\ArrayType\ArrayOfString $activeTroubleConditions
     * @return \CustomerManagement\StructType\VideoDeviceInformation
     */
    public function setActiveTroubleConditions(\CustomerManagement\ArrayType\ArrayOfString $activeTroubleConditions = null)
    {
        $this->ActiveTroubleConditions = $activeTroubleConditions;
        return $this;
    }
}
