<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetZWaveRoutingTableOutput StructType
 * @subpackage Structs
 */
class GetZWaveRoutingTableOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The ZWaveRoutingTableInfoList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfZWaveRoutingTableInfo
     */
    public $ZWaveRoutingTableInfoList;
    /**
     * Constructor method for GetZWaveRoutingTableOutput
     * @uses GetZWaveRoutingTableOutput::setSuccess()
     * @uses GetZWaveRoutingTableOutput::setErrorMessage()
     * @uses GetZWaveRoutingTableOutput::setZWaveRoutingTableInfoList()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfZWaveRoutingTableInfo $zWaveRoutingTableInfoList
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfZWaveRoutingTableInfo $zWaveRoutingTableInfoList = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setZWaveRoutingTableInfoList($zWaveRoutingTableInfoList);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetZWaveRoutingTableOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetZWaveRoutingTableOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get ZWaveRoutingTableInfoList value
     * @return \CustomerManagement\ArrayType\ArrayOfZWaveRoutingTableInfo|null
     */
    public function getZWaveRoutingTableInfoList()
    {
        return $this->ZWaveRoutingTableInfoList;
    }
    /**
     * Set ZWaveRoutingTableInfoList value
     * @param \CustomerManagement\ArrayType\ArrayOfZWaveRoutingTableInfo $zWaveRoutingTableInfoList
     * @return \CustomerManagement\StructType\GetZWaveRoutingTableOutput
     */
    public function setZWaveRoutingTableInfoList(\CustomerManagement\ArrayType\ArrayOfZWaveRoutingTableInfo $zWaveRoutingTableInfoList = null)
    {
        $this->ZWaveRoutingTableInfoList = $zWaveRoutingTableInfoList;
        return $this;
    }
}
