<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduledServiceDateInfoV2 StructType
 * @subpackage Structs
 */
class ScheduledServiceDateInfoV2 extends AbstractStructBase
{
    /**
     * The AppointmentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AppointmentId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The ServiceDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceDateUtc;
    /**
     * The CustomerLocalizedServiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CustomerLocalizedServiceDate;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The TechnicianId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TechnicianId;
    /**
     * The ConfirmationSent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ConfirmationSent;
    /**
     * The SendReminder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SendReminder;
    /**
     * The ServiceDateEndRangeUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ServiceDateEndRangeUtc;
    /**
     * The CustomerLocalizedServiceDateEndRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CustomerLocalizedServiceDateEndRange;
    /**
     * The IsVirtual
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsVirtual;
    /**
     * The IncludeRepInfoInEmails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeRepInfoInEmails;
    /**
     * The EstimatedDurationMinutes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EstimatedDurationMinutes;
    /**
     * The UpsellOfferIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfInt
     */
    public $UpsellOfferIds;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The AppointmentTypes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum
     */
    public $AppointmentTypes;
    /**
     * The MeetingLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeetingLocation;
    /**
     * The CustomerFacingInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerFacingInfo;
    /**
     * Constructor method for ScheduledServiceDateInfoV2
     * @uses ScheduledServiceDateInfoV2::setAppointmentId()
     * @uses ScheduledServiceDateInfoV2::setStatus()
     * @uses ScheduledServiceDateInfoV2::setServiceDateUtc()
     * @uses ScheduledServiceDateInfoV2::setCustomerLocalizedServiceDate()
     * @uses ScheduledServiceDateInfoV2::setCustomerId()
     * @uses ScheduledServiceDateInfoV2::setTechnicianId()
     * @uses ScheduledServiceDateInfoV2::setConfirmationSent()
     * @uses ScheduledServiceDateInfoV2::setSendReminder()
     * @uses ScheduledServiceDateInfoV2::setServiceDateEndRangeUtc()
     * @uses ScheduledServiceDateInfoV2::setCustomerLocalizedServiceDateEndRange()
     * @uses ScheduledServiceDateInfoV2::setIsVirtual()
     * @uses ScheduledServiceDateInfoV2::setIncludeRepInfoInEmails()
     * @uses ScheduledServiceDateInfoV2::setEstimatedDurationMinutes()
     * @uses ScheduledServiceDateInfoV2::setUpsellOfferIds()
     * @uses ScheduledServiceDateInfoV2::setNotes()
     * @uses ScheduledServiceDateInfoV2::setAppointmentTypes()
     * @uses ScheduledServiceDateInfoV2::setMeetingLocation()
     * @uses ScheduledServiceDateInfoV2::setCustomerFacingInfo()
     * @param int $appointmentId
     * @param string $status
     * @param string $serviceDateUtc
     * @param string $customerLocalizedServiceDate
     * @param int $customerId
     * @param int $technicianId
     * @param bool $confirmationSent
     * @param bool $sendReminder
     * @param string $serviceDateEndRangeUtc
     * @param string $customerLocalizedServiceDateEndRange
     * @param bool $isVirtual
     * @param bool $includeRepInfoInEmails
     * @param int $estimatedDurationMinutes
     * @param \CustomerManagement\ArrayType\ArrayOfInt $upsellOfferIds
     * @param string $notes
     * @param \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentTypes
     * @param string $meetingLocation
     * @param string $customerFacingInfo
     */
    public function __construct($appointmentId = null, $status = null, $serviceDateUtc = null, $customerLocalizedServiceDate = null, $customerId = null, $technicianId = null, $confirmationSent = null, $sendReminder = null, $serviceDateEndRangeUtc = null, $customerLocalizedServiceDateEndRange = null, $isVirtual = null, $includeRepInfoInEmails = null, $estimatedDurationMinutes = null, \CustomerManagement\ArrayType\ArrayOfInt $upsellOfferIds = null, $notes = null, \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentTypes = null, $meetingLocation = null, $customerFacingInfo = null)
    {
        $this
            ->setAppointmentId($appointmentId)
            ->setStatus($status)
            ->setServiceDateUtc($serviceDateUtc)
            ->setCustomerLocalizedServiceDate($customerLocalizedServiceDate)
            ->setCustomerId($customerId)
            ->setTechnicianId($technicianId)
            ->setConfirmationSent($confirmationSent)
            ->setSendReminder($sendReminder)
            ->setServiceDateEndRangeUtc($serviceDateEndRangeUtc)
            ->setCustomerLocalizedServiceDateEndRange($customerLocalizedServiceDateEndRange)
            ->setIsVirtual($isVirtual)
            ->setIncludeRepInfoInEmails($includeRepInfoInEmails)
            ->setEstimatedDurationMinutes($estimatedDurationMinutes)
            ->setUpsellOfferIds($upsellOfferIds)
            ->setNotes($notes)
            ->setAppointmentTypes($appointmentTypes)
            ->setMeetingLocation($meetingLocation)
            ->setCustomerFacingInfo($customerFacingInfo);
    }
    /**
     * Get AppointmentId value
     * @return int
     */
    public function getAppointmentId()
    {
        return $this->AppointmentId;
    }
    /**
     * Set AppointmentId value
     * @param int $appointmentId
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setAppointmentId($appointmentId = null)
    {
        // validation for constraint: int
        if (!is_null($appointmentId) && !(is_int($appointmentId) || ctype_digit($appointmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($appointmentId, true), gettype($appointmentId)), __LINE__);
        }
        $this->AppointmentId = $appointmentId;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \CustomerManagement\EnumType\ScheduledServiceDateStatus::valueIsValid()
     * @uses \CustomerManagement\EnumType\ScheduledServiceDateStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\ScheduledServiceDateStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\ScheduledServiceDateStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \CustomerManagement\EnumType\ScheduledServiceDateStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ServiceDateUtc value
     * @return string
     */
    public function getServiceDateUtc()
    {
        return $this->ServiceDateUtc;
    }
    /**
     * Set ServiceDateUtc value
     * @param string $serviceDateUtc
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setServiceDateUtc($serviceDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDateUtc) && !is_string($serviceDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDateUtc, true), gettype($serviceDateUtc)), __LINE__);
        }
        $this->ServiceDateUtc = $serviceDateUtc;
        return $this;
    }
    /**
     * Get CustomerLocalizedServiceDate value
     * @return string
     */
    public function getCustomerLocalizedServiceDate()
    {
        return $this->CustomerLocalizedServiceDate;
    }
    /**
     * Set CustomerLocalizedServiceDate value
     * @param string $customerLocalizedServiceDate
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setCustomerLocalizedServiceDate($customerLocalizedServiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($customerLocalizedServiceDate) && !is_string($customerLocalizedServiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerLocalizedServiceDate, true), gettype($customerLocalizedServiceDate)), __LINE__);
        }
        $this->CustomerLocalizedServiceDate = $customerLocalizedServiceDate;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get TechnicianId value
     * @return int
     */
    public function getTechnicianId()
    {
        return $this->TechnicianId;
    }
    /**
     * Set TechnicianId value
     * @param int $technicianId
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setTechnicianId($technicianId = null)
    {
        // validation for constraint: int
        if (!is_null($technicianId) && !(is_int($technicianId) || ctype_digit($technicianId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($technicianId, true), gettype($technicianId)), __LINE__);
        }
        $this->TechnicianId = $technicianId;
        return $this;
    }
    /**
     * Get ConfirmationSent value
     * @return bool
     */
    public function getConfirmationSent()
    {
        return $this->ConfirmationSent;
    }
    /**
     * Set ConfirmationSent value
     * @param bool $confirmationSent
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setConfirmationSent($confirmationSent = null)
    {
        // validation for constraint: boolean
        if (!is_null($confirmationSent) && !is_bool($confirmationSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($confirmationSent, true), gettype($confirmationSent)), __LINE__);
        }
        $this->ConfirmationSent = $confirmationSent;
        return $this;
    }
    /**
     * Get SendReminder value
     * @return bool
     */
    public function getSendReminder()
    {
        return $this->SendReminder;
    }
    /**
     * Set SendReminder value
     * @param bool $sendReminder
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setSendReminder($sendReminder = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendReminder) && !is_bool($sendReminder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendReminder, true), gettype($sendReminder)), __LINE__);
        }
        $this->SendReminder = $sendReminder;
        return $this;
    }
    /**
     * Get ServiceDateEndRangeUtc value
     * @return string
     */
    public function getServiceDateEndRangeUtc()
    {
        return $this->ServiceDateEndRangeUtc;
    }
    /**
     * Set ServiceDateEndRangeUtc value
     * @param string $serviceDateEndRangeUtc
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setServiceDateEndRangeUtc($serviceDateEndRangeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDateEndRangeUtc) && !is_string($serviceDateEndRangeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDateEndRangeUtc, true), gettype($serviceDateEndRangeUtc)), __LINE__);
        }
        $this->ServiceDateEndRangeUtc = $serviceDateEndRangeUtc;
        return $this;
    }
    /**
     * Get CustomerLocalizedServiceDateEndRange value
     * @return string
     */
    public function getCustomerLocalizedServiceDateEndRange()
    {
        return $this->CustomerLocalizedServiceDateEndRange;
    }
    /**
     * Set CustomerLocalizedServiceDateEndRange value
     * @param string $customerLocalizedServiceDateEndRange
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setCustomerLocalizedServiceDateEndRange($customerLocalizedServiceDateEndRange = null)
    {
        // validation for constraint: string
        if (!is_null($customerLocalizedServiceDateEndRange) && !is_string($customerLocalizedServiceDateEndRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerLocalizedServiceDateEndRange, true), gettype($customerLocalizedServiceDateEndRange)), __LINE__);
        }
        $this->CustomerLocalizedServiceDateEndRange = $customerLocalizedServiceDateEndRange;
        return $this;
    }
    /**
     * Get IsVirtual value
     * @return bool
     */
    public function getIsVirtual()
    {
        return $this->IsVirtual;
    }
    /**
     * Set IsVirtual value
     * @param bool $isVirtual
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setIsVirtual($isVirtual = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVirtual) && !is_bool($isVirtual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVirtual, true), gettype($isVirtual)), __LINE__);
        }
        $this->IsVirtual = $isVirtual;
        return $this;
    }
    /**
     * Get IncludeRepInfoInEmails value
     * @return bool
     */
    public function getIncludeRepInfoInEmails()
    {
        return $this->IncludeRepInfoInEmails;
    }
    /**
     * Set IncludeRepInfoInEmails value
     * @param bool $includeRepInfoInEmails
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setIncludeRepInfoInEmails($includeRepInfoInEmails = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeRepInfoInEmails) && !is_bool($includeRepInfoInEmails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeRepInfoInEmails, true), gettype($includeRepInfoInEmails)), __LINE__);
        }
        $this->IncludeRepInfoInEmails = $includeRepInfoInEmails;
        return $this;
    }
    /**
     * Get EstimatedDurationMinutes value
     * @return int
     */
    public function getEstimatedDurationMinutes()
    {
        return $this->EstimatedDurationMinutes;
    }
    /**
     * Set EstimatedDurationMinutes value
     * @param int $estimatedDurationMinutes
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setEstimatedDurationMinutes($estimatedDurationMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($estimatedDurationMinutes) && !(is_int($estimatedDurationMinutes) || ctype_digit($estimatedDurationMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($estimatedDurationMinutes, true), gettype($estimatedDurationMinutes)), __LINE__);
        }
        $this->EstimatedDurationMinutes = $estimatedDurationMinutes;
        return $this;
    }
    /**
     * Get UpsellOfferIds value
     * @return \CustomerManagement\ArrayType\ArrayOfInt|null
     */
    public function getUpsellOfferIds()
    {
        return $this->UpsellOfferIds;
    }
    /**
     * Set UpsellOfferIds value
     * @param \CustomerManagement\ArrayType\ArrayOfInt $upsellOfferIds
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setUpsellOfferIds(\CustomerManagement\ArrayType\ArrayOfInt $upsellOfferIds = null)
    {
        $this->UpsellOfferIds = $upsellOfferIds;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get AppointmentTypes value
     * @return \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum|null
     */
    public function getAppointmentTypes()
    {
        return $this->AppointmentTypes;
    }
    /**
     * Set AppointmentTypes value
     * @param \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentTypes
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setAppointmentTypes(\CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentTypes = null)
    {
        $this->AppointmentTypes = $appointmentTypes;
        return $this;
    }
    /**
     * Get MeetingLocation value
     * @return string|null
     */
    public function getMeetingLocation()
    {
        return $this->MeetingLocation;
    }
    /**
     * Set MeetingLocation value
     * @param string $meetingLocation
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setMeetingLocation($meetingLocation = null)
    {
        // validation for constraint: string
        if (!is_null($meetingLocation) && !is_string($meetingLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingLocation, true), gettype($meetingLocation)), __LINE__);
        }
        $this->MeetingLocation = $meetingLocation;
        return $this;
    }
    /**
     * Get CustomerFacingInfo value
     * @return string|null
     */
    public function getCustomerFacingInfo()
    {
        return $this->CustomerFacingInfo;
    }
    /**
     * Set CustomerFacingInfo value
     * @param string $customerFacingInfo
     * @return \CustomerManagement\StructType\ScheduledServiceDateInfoV2
     */
    public function setCustomerFacingInfo($customerFacingInfo = null)
    {
        // validation for constraint: string
        if (!is_null($customerFacingInfo) && !is_string($customerFacingInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerFacingInfo, true), gettype($customerFacingInfo)), __LINE__);
        }
        $this->CustomerFacingInfo = $customerFacingInfo;
        return $this;
    }
}
