<?php

namespace CustomerManagement\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for GsmRegistrationStateEnum EnumType
 * @subpackage Enumerations
 */
class GsmRegistrationStateEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotRegisteredIdle'
     * @return string 'NotRegisteredIdle'
     */
    const VALUE_NOT_REGISTERED_IDLE = 'NotRegisteredIdle';
    /**
     * Constant for value 'InNetwork'
     * @return string 'InNetwork'
     */
    const VALUE_IN_NETWORK = 'InNetwork';
    /**
     * Constant for value 'NotRegisteredTrying'
     * @return string 'NotRegisteredTrying'
     */
    const VALUE_NOT_REGISTERED_TRYING = 'NotRegisteredTrying';
    /**
     * Constant for value 'NotRegisteredNotActive'
     * @return string 'NotRegisteredNotActive'
     */
    const VALUE_NOT_REGISTERED_NOT_ACTIVE = 'NotRegisteredNotActive';
    /**
     * Constant for value 'UnknownByPanel'
     * @return string 'UnknownByPanel'
     */
    const VALUE_UNKNOWN_BY_PANEL = 'UnknownByPanel';
    /**
     * Constant for value 'Roaming'
     * @return string 'Roaming'
     */
    const VALUE_ROAMING = 'Roaming';
    /**
     * Constant for value 'TimedOut'
     * @return string 'TimedOut'
     */
    const VALUE_TIMED_OUT = 'TimedOut';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_REGISTERED_IDLE
     * @uses self::VALUE_IN_NETWORK
     * @uses self::VALUE_NOT_REGISTERED_TRYING
     * @uses self::VALUE_NOT_REGISTERED_NOT_ACTIVE
     * @uses self::VALUE_UNKNOWN_BY_PANEL
     * @uses self::VALUE_ROAMING
     * @uses self::VALUE_TIMED_OUT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_REGISTERED_IDLE,
            self::VALUE_IN_NETWORK,
            self::VALUE_NOT_REGISTERED_TRYING,
            self::VALUE_NOT_REGISTERED_NOT_ACTIVE,
            self::VALUE_UNKNOWN_BY_PANEL,
            self::VALUE_ROAMING,
            self::VALUE_TIMED_OUT,
        );
    }
}
