<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for DeviceTypeEnum EnumType
 * @subpackage Enumerations
 */
class DeviceTypeEnum
{
    /**
     * Constant for value 'DefaultSettings'
     * @return string 'DefaultSettings'
     */
    const VALUE_DEFAULT_SETTINGS = 'DefaultSettings';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Contact'
     * @return string 'Contact'
     */
    const VALUE_CONTACT = 'Contact';
    /**
     * Constant for value 'Motion'
     * @return string 'Motion'
     */
    const VALUE_MOTION = 'Motion';
    /**
     * Constant for value 'Sound'
     * @return string 'Sound'
     */
    const VALUE_SOUND = 'Sound';
    /**
     * Constant for value 'Breakage'
     * @return string 'Breakage'
     */
    const VALUE_BREAKAGE = 'Breakage';
    /**
     * Constant for value 'SmokeHeat'
     * @return string 'SmokeHeat'
     */
    const VALUE_SMOKE_HEAT = 'SmokeHeat';
    /**
     * Constant for value 'CarbonMonoxide'
     * @return string 'CarbonMonoxide'
     */
    const VALUE_CARBON_MONOXIDE = 'CarbonMonoxide';
    /**
     * Constant for value 'Radon'
     * @return string 'Radon'
     */
    const VALUE_RADON = 'Radon';
    /**
     * Constant for value 'Temperature'
     * @return string 'Temperature'
     */
    const VALUE_TEMPERATURE = 'Temperature';
    /**
     * Constant for value 'PanicButton'
     * @return string 'PanicButton'
     */
    const VALUE_PANIC_BUTTON = 'PanicButton';
    /**
     * Constant for value 'Control'
     * @return string 'Control'
     */
    const VALUE_CONTROL = 'Control';
    /**
     * Constant for value 'Camera'
     * @return string 'Camera'
     */
    const VALUE_CAMERA = 'Camera';
    /**
     * Constant for value 'Light'
     * @return string 'Light'
     */
    const VALUE_LIGHT = 'Light';
    /**
     * Constant for value 'Gps'
     * @return string 'Gps'
     */
    const VALUE_GPS = 'Gps';
    /**
     * Constant for value 'Siren'
     * @return string 'Siren'
     */
    const VALUE_SIREN = 'Siren';
    /**
     * Constant for value 'OutputModule'
     * @return string 'OutputModule'
     */
    const VALUE_OUTPUT_MODULE = 'OutputModule';
    /**
     * Constant for value 'Water'
     * @return string 'Water'
     */
    const VALUE_WATER = 'Water';
    /**
     * Constant for value 'LightSwitchControl'
     * @return string 'LightSwitchControl'
     */
    const VALUE_LIGHT_SWITCH_CONTROL = 'LightSwitchControl';
    /**
     * Constant for value 'Partition'
     * @return string 'Partition'
     */
    const VALUE_PARTITION = 'Partition';
    /**
     * Constant for value 'Glassbreak'
     * @return string 'Glassbreak'
     */
    const VALUE_GLASSBREAK = 'Glassbreak';
    /**
     * Constant for value 'ZwaveThermostat'
     * @return string 'ZwaveThermostat'
     */
    const VALUE_ZWAVE_THERMOSTAT = 'ZwaveThermostat';
    /**
     * Constant for value 'ZwaveLock'
     * @return string 'ZwaveLock'
     */
    const VALUE_ZWAVE_LOCK = 'ZwaveLock';
    /**
     * Constant for value 'ZwaveController'
     * @return string 'ZwaveController'
     */
    const VALUE_ZWAVE_CONTROLLER = 'ZwaveController';
    /**
     * Constant for value 'ZwaveUnknown'
     * @return string 'ZwaveUnknown'
     */
    const VALUE_ZWAVE_UNKNOWN = 'ZwaveUnknown';
    /**
     * Constant for value 'Occupancy'
     * @return string 'Occupancy'
     */
    const VALUE_OCCUPANCY = 'Occupancy';
    /**
     * Constant for value 'PushButton'
     * @return string 'PushButton'
     */
    const VALUE_PUSH_BUTTON = 'PushButton';
    /**
     * Constant for value 'Orientation'
     * @return string 'Orientation'
     */
    const VALUE_ORIENTATION = 'Orientation';
    /**
     * Constant for value 'ZwaveLight'
     * @return string 'ZwaveLight'
     */
    const VALUE_ZWAVE_LIGHT = 'ZwaveLight';
    /**
     * Constant for value 'ZwaveSiren'
     * @return string 'ZwaveSiren'
     */
    const VALUE_ZWAVE_SIREN = 'ZwaveSiren';
    /**
     * Constant for value 'ImageSensor'
     * @return string 'ImageSensor'
     */
    const VALUE_IMAGE_SENSOR = 'ImageSensor';
    /**
     * Constant for value 'PointSafe'
     * @return string 'PointSafe'
     */
    const VALUE_POINT_SAFE = 'PointSafe';
    /**
     * Constant for value 'PowerMeter'
     * @return string 'PowerMeter'
     */
    const VALUE_POWER_METER = 'PowerMeter';
    /**
     * Constant for value 'SevereWeather'
     * @return string 'SevereWeather'
     */
    const VALUE_SEVERE_WEATHER = 'SevereWeather';
    /**
     * Constant for value 'RemotePanic'
     * @return string 'RemotePanic'
     */
    const VALUE_REMOTE_PANIC = 'RemotePanic';
    /**
     * Constant for value 'LocalGateway'
     * @return string 'LocalGateway'
     */
    const VALUE_LOCAL_GATEWAY = 'LocalGateway';
    /**
     * Constant for value 'GarageDoor'
     * @return string 'GarageDoor'
     */
    const VALUE_GARAGE_DOOR = 'GarageDoor';
    /**
     * Constant for value 'Doorbell'
     * @return string 'Doorbell'
     */
    const VALUE_DOORBELL = 'Doorbell';
    /**
     * Constant for value 'WirelessRepeater'
     * @return string 'WirelessRepeater'
     */
    const VALUE_WIRELESS_REPEATER = 'WirelessRepeater';
    /**
     * Constant for value 'ExpansionModule'
     * @return string 'ExpansionModule'
     */
    const VALUE_EXPANSION_MODULE = 'ExpansionModule';
    /**
     * Constant for value 'WaterValve'
     * @return string 'WaterValve'
     */
    const VALUE_WATER_VALVE = 'WaterValve';
    /**
     * Constant for value 'TemperatureSensor'
     * @return string 'TemperatureSensor'
     */
    const VALUE_TEMPERATURE_SENSOR = 'TemperatureSensor';
    /**
     * Constant for value 'Tracker'
     * @return string 'Tracker'
     */
    const VALUE_TRACKER = 'Tracker';
    /**
     * Constant for value 'Medication'
     * @return string 'Medication'
     */
    const VALUE_MEDICATION = 'Medication';
    /**
     * Constant for value 'WaterMultiFunction'
     * @return string 'WaterMultiFunction'
     */
    const VALUE_WATER_MULTI_FUNCTION = 'WaterMultiFunction';
    /**
     * Constant for value 'WaterFlood'
     * @return string 'WaterFlood'
     */
    const VALUE_WATER_FLOOD = 'WaterFlood';
    /**
     * Constant for value 'CarMonitor'
     * @return string 'CarMonitor'
     */
    const VALUE_CAR_MONITOR = 'CarMonitor';
    /**
     * Constant for value 'OutputExpander'
     * @return string 'OutputExpander'
     */
    const VALUE_OUTPUT_EXPANDER = 'OutputExpander';
    /**
     * Constant for value 'PowerSupply'
     * @return string 'PowerSupply'
     */
    const VALUE_POWER_SUPPLY = 'PowerSupply';
    /**
     * Constant for value 'HighCurrentOutput'
     * @return string 'HighCurrentOutput'
     */
    const VALUE_HIGH_CURRENT_OUTPUT = 'HighCurrentOutput';
    /**
     * Constant for value 'IQShock'
     * @return string 'IQShock'
     */
    const VALUE_IQSHOCK = 'IQShock';
    /**
     * Constant for value 'IQDoorBell'
     * @return string 'IQDoorBell'
     */
    const VALUE_IQDOOR_BELL = 'IQDoorBell';
    /**
     * Constant for value 'ContactMultiFunction'
     * @return string 'ContactMultiFunction'
     */
    const VALUE_CONTACT_MULTI_FUNCTION = 'ContactMultiFunction';
    /**
     * Constant for value 'IQSmokeMultiFunction'
     * @return string 'IQSmokeMultiFunction'
     */
    const VALUE_IQSMOKE_MULTI_FUNCTION = 'IQSmokeMultiFunction';
    /**
     * Constant for value 'ShockOthers'
     * @return string 'ShockOthers'
     */
    const VALUE_SHOCK_OTHERS = 'ShockOthers';
    /**
     * Constant for value 'RFTransceiver'
     * @return string 'RFTransceiver'
     */
    const VALUE_RFTRANSCEIVER = 'RFTransceiver';
    /**
     * Constant for value 'AudioModule'
     * @return string 'AudioModule'
     */
    const VALUE_AUDIO_MODULE = 'AudioModule';
    /**
     * Constant for value 'Gas'
     * @return string 'Gas'
     */
    const VALUE_GAS = 'Gas';
    /**
     * Constant for value 'RemoteSwitchAccessory'
     * @return string 'RemoteSwitchAccessory'
     */
    const VALUE_REMOTE_SWITCH_ACCESSORY = 'RemoteSwitchAccessory';
    /**
     * Constant for value 'AuxiliarySensor'
     * @return string 'AuxiliarySensor'
     */
    const VALUE_AUXILIARY_SENSOR = 'AuxiliarySensor';
    /**
     * Constant for value 'SecuredDevice'
     * @return string 'SecuredDevice'
     */
    const VALUE_SECURED_DEVICE = 'SecuredDevice';
    /**
     * Constant for value 'IrrigationZone'
     * @return string 'IrrigationZone'
     */
    const VALUE_IRRIGATION_ZONE = 'IrrigationZone';
    /**
     * Constant for value 'WaterMeter'
     * @return string 'WaterMeter'
     */
    const VALUE_WATER_METER = 'WaterMeter';
    /**
     * Constant for value 'PropaneMonitor'
     * @return string 'PropaneMonitor'
     */
    const VALUE_PROPANE_MONITOR = 'PropaneMonitor';
    /**
     * Constant for value 'TroubleSensor'
     * @return string 'TroubleSensor'
     */
    const VALUE_TROUBLE_SENSOR = 'TroubleSensor';
    /**
     * Constant for value 'ClimaxPIRCamera'
     * @return string 'ClimaxPIRCamera'
     */
    const VALUE_CLIMAX_PIRCAMERA = 'ClimaxPIRCamera';
    /**
     * Constant for value 'DSCPIRCamera'
     * @return string 'DSCPIRCamera'
     */
    const VALUE_DSCPIRCAMERA = 'DSCPIRCamera';
    /**
     * Constant for value 'QolsysPanelCamera'
     * @return string 'QolsysPanelCamera'
     */
    const VALUE_QOLSYS_PANEL_CAMERA = 'QolsysPanelCamera';
    /**
     * Constant for value 'BluetoothDevice'
     * @return string 'BluetoothDevice'
     */
    const VALUE_BLUETOOTH_DEVICE = 'BluetoothDevice';
    /**
     * Constant for value 'IrrigationController'
     * @return string 'IrrigationController'
     */
    const VALUE_IRRIGATION_CONTROLLER = 'IrrigationController';
    /**
     * Constant for value 'Remote'
     * @return string 'Remote'
     */
    const VALUE_REMOTE = 'Remote';
    /**
     * Constant for value 'MercurySCP'
     * @return string 'MercurySCP'
     */
    const VALUE_MERCURY_SCP = 'MercurySCP';
    /**
     * Constant for value 'AccessCardReader'
     * @return string 'AccessCardReader'
     */
    const VALUE_ACCESS_CARD_READER = 'AccessCardReader';
    /**
     * Constant for value 'OilGauge'
     * @return string 'OilGauge'
     */
    const VALUE_OIL_GAUGE = 'OilGauge';
    /**
     * Constant for value 'BusZoneExpander'
     * @return string 'BusZoneExpander'
     */
    const VALUE_BUS_ZONE_EXPANDER = 'BusZoneExpander';
    /**
     * Constant for value 'SioPanel'
     * @return string 'SioPanel'
     */
    const VALUE_SIO_PANEL = 'SioPanel';
    /**
     * Constant for value 'ValveSwitch'
     * @return string 'ValveSwitch'
     */
    const VALUE_VALVE_SWITCH = 'ValveSwitch';
    /**
     * Constant for value 'AudioController'
     * @return string 'AudioController'
     */
    const VALUE_AUDIO_CONTROLLER = 'AudioController';
    /**
     * Constant for value 'AudioZone'
     * @return string 'AudioZone'
     */
    const VALUE_AUDIO_ZONE = 'AudioZone';
    /**
     * Constant for value 'IQTakeoverModule'
     * @return string 'IQTakeoverModule'
     */
    const VALUE_IQTAKEOVER_MODULE = 'IQTakeoverModule';
    /**
     * Constant for value 'IQTranslator'
     * @return string 'IQTranslator'
     */
    const VALUE_IQTRANSLATOR = 'IQTranslator';
    /**
     * Constant for value 'WiFiAccessPoint'
     * @return string 'WiFiAccessPoint'
     */
    const VALUE_WI_FI_ACCESS_POINT = 'WiFiAccessPoint';
    /**
     * Constant for value 'IQPanelGlassbreak'
     * @return string 'IQPanelGlassbreak'
     */
    const VALUE_IQPANEL_GLASSBREAK = 'IQPanelGlassbreak';
    /**
     * Constant for value 'WifiTablet'
     * @return string 'WifiTablet'
     */
    const VALUE_WIFI_TABLET = 'WifiTablet';
    /**
     * Constant for value 'HighCurrentPowerSupply'
     * @return string 'HighCurrentPowerSupply'
     */
    const VALUE_HIGH_CURRENT_POWER_SUPPLY = 'HighCurrentPowerSupply';
    /**
     * Constant for value 'IOExpanderModule'
     * @return string 'IOExpanderModule'
     */
    const VALUE_IOEXPANDER_MODULE = 'IOExpanderModule';
    /**
     * Constant for value 'CorbusRepeater'
     * @return string 'CorbusRepeater'
     */
    const VALUE_CORBUS_REPEATER = 'CorbusRepeater';
    /**
     * Constant for value 'IQPanelBluetoothSpeaker'
     * @return string 'IQPanelBluetoothSpeaker'
     */
    const VALUE_IQPANEL_BLUETOOTH_SPEAKER = 'IQPanelBluetoothSpeaker';
    /**
     * Constant for value 'IQPanelMotionDetector'
     * @return string 'IQPanelMotionDetector'
     */
    const VALUE_IQPANEL_MOTION_DETECTOR = 'IQPanelMotionDetector';
    /**
     * Constant for value 'Controller'
     * @return string 'Controller'
     */
    const VALUE_CONTROLLER = 'Controller';
    /**
     * Constant for value 'HoneywellPanelCamera'
     * @return string 'HoneywellPanelCamera'
     */
    const VALUE_HONEYWELL_PANEL_CAMERA = 'HoneywellPanelCamera';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT_SETTINGS
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_CONTACT
     * @uses self::VALUE_MOTION
     * @uses self::VALUE_SOUND
     * @uses self::VALUE_BREAKAGE
     * @uses self::VALUE_SMOKE_HEAT
     * @uses self::VALUE_CARBON_MONOXIDE
     * @uses self::VALUE_RADON
     * @uses self::VALUE_TEMPERATURE
     * @uses self::VALUE_PANIC_BUTTON
     * @uses self::VALUE_CONTROL
     * @uses self::VALUE_CAMERA
     * @uses self::VALUE_LIGHT
     * @uses self::VALUE_GPS
     * @uses self::VALUE_SIREN
     * @uses self::VALUE_OUTPUT_MODULE
     * @uses self::VALUE_WATER
     * @uses self::VALUE_LIGHT_SWITCH_CONTROL
     * @uses self::VALUE_PARTITION
     * @uses self::VALUE_GLASSBREAK
     * @uses self::VALUE_ZWAVE_THERMOSTAT
     * @uses self::VALUE_ZWAVE_LOCK
     * @uses self::VALUE_ZWAVE_CONTROLLER
     * @uses self::VALUE_ZWAVE_UNKNOWN
     * @uses self::VALUE_OCCUPANCY
     * @uses self::VALUE_PUSH_BUTTON
     * @uses self::VALUE_ORIENTATION
     * @uses self::VALUE_ZWAVE_LIGHT
     * @uses self::VALUE_ZWAVE_SIREN
     * @uses self::VALUE_IMAGE_SENSOR
     * @uses self::VALUE_POINT_SAFE
     * @uses self::VALUE_POWER_METER
     * @uses self::VALUE_SEVERE_WEATHER
     * @uses self::VALUE_REMOTE_PANIC
     * @uses self::VALUE_LOCAL_GATEWAY
     * @uses self::VALUE_GARAGE_DOOR
     * @uses self::VALUE_DOORBELL
     * @uses self::VALUE_WIRELESS_REPEATER
     * @uses self::VALUE_EXPANSION_MODULE
     * @uses self::VALUE_WATER_VALVE
     * @uses self::VALUE_TEMPERATURE_SENSOR
     * @uses self::VALUE_TRACKER
     * @uses self::VALUE_MEDICATION
     * @uses self::VALUE_WATER_MULTI_FUNCTION
     * @uses self::VALUE_WATER_FLOOD
     * @uses self::VALUE_CAR_MONITOR
     * @uses self::VALUE_OUTPUT_EXPANDER
     * @uses self::VALUE_POWER_SUPPLY
     * @uses self::VALUE_HIGH_CURRENT_OUTPUT
     * @uses self::VALUE_IQSHOCK
     * @uses self::VALUE_IQDOOR_BELL
     * @uses self::VALUE_CONTACT_MULTI_FUNCTION
     * @uses self::VALUE_IQSMOKE_MULTI_FUNCTION
     * @uses self::VALUE_SHOCK_OTHERS
     * @uses self::VALUE_RFTRANSCEIVER
     * @uses self::VALUE_AUDIO_MODULE
     * @uses self::VALUE_GAS
     * @uses self::VALUE_REMOTE_SWITCH_ACCESSORY
     * @uses self::VALUE_AUXILIARY_SENSOR
     * @uses self::VALUE_SECURED_DEVICE
     * @uses self::VALUE_IRRIGATION_ZONE
     * @uses self::VALUE_WATER_METER
     * @uses self::VALUE_PROPANE_MONITOR
     * @uses self::VALUE_TROUBLE_SENSOR
     * @uses self::VALUE_CLIMAX_PIRCAMERA
     * @uses self::VALUE_DSCPIRCAMERA
     * @uses self::VALUE_QOLSYS_PANEL_CAMERA
     * @uses self::VALUE_BLUETOOTH_DEVICE
     * @uses self::VALUE_IRRIGATION_CONTROLLER
     * @uses self::VALUE_REMOTE
     * @uses self::VALUE_MERCURY_SCP
     * @uses self::VALUE_ACCESS_CARD_READER
     * @uses self::VALUE_OIL_GAUGE
     * @uses self::VALUE_BUS_ZONE_EXPANDER
     * @uses self::VALUE_SIO_PANEL
     * @uses self::VALUE_VALVE_SWITCH
     * @uses self::VALUE_AUDIO_CONTROLLER
     * @uses self::VALUE_AUDIO_ZONE
     * @uses self::VALUE_IQTAKEOVER_MODULE
     * @uses self::VALUE_IQTRANSLATOR
     * @uses self::VALUE_WI_FI_ACCESS_POINT
     * @uses self::VALUE_IQPANEL_GLASSBREAK
     * @uses self::VALUE_WIFI_TABLET
     * @uses self::VALUE_HIGH_CURRENT_POWER_SUPPLY
     * @uses self::VALUE_IOEXPANDER_MODULE
     * @uses self::VALUE_CORBUS_REPEATER
     * @uses self::VALUE_IQPANEL_BLUETOOTH_SPEAKER
     * @uses self::VALUE_IQPANEL_MOTION_DETECTOR
     * @uses self::VALUE_CONTROLLER
     * @uses self::VALUE_HONEYWELL_PANEL_CAMERA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT_SETTINGS,
            self::VALUE_UNKNOWN,
            self::VALUE_CONTACT,
            self::VALUE_MOTION,
            self::VALUE_SOUND,
            self::VALUE_BREAKAGE,
            self::VALUE_SMOKE_HEAT,
            self::VALUE_CARBON_MONOXIDE,
            self::VALUE_RADON,
            self::VALUE_TEMPERATURE,
            self::VALUE_PANIC_BUTTON,
            self::VALUE_CONTROL,
            self::VALUE_CAMERA,
            self::VALUE_LIGHT,
            self::VALUE_GPS,
            self::VALUE_SIREN,
            self::VALUE_OUTPUT_MODULE,
            self::VALUE_WATER,
            self::VALUE_LIGHT_SWITCH_CONTROL,
            self::VALUE_PARTITION,
            self::VALUE_GLASSBREAK,
            self::VALUE_ZWAVE_THERMOSTAT,
            self::VALUE_ZWAVE_LOCK,
            self::VALUE_ZWAVE_CONTROLLER,
            self::VALUE_ZWAVE_UNKNOWN,
            self::VALUE_OCCUPANCY,
            self::VALUE_PUSH_BUTTON,
            self::VALUE_ORIENTATION,
            self::VALUE_ZWAVE_LIGHT,
            self::VALUE_ZWAVE_SIREN,
            self::VALUE_IMAGE_SENSOR,
            self::VALUE_POINT_SAFE,
            self::VALUE_POWER_METER,
            self::VALUE_SEVERE_WEATHER,
            self::VALUE_REMOTE_PANIC,
            self::VALUE_LOCAL_GATEWAY,
            self::VALUE_GARAGE_DOOR,
            self::VALUE_DOORBELL,
            self::VALUE_WIRELESS_REPEATER,
            self::VALUE_EXPANSION_MODULE,
            self::VALUE_WATER_VALVE,
            self::VALUE_TEMPERATURE_SENSOR,
            self::VALUE_TRACKER,
            self::VALUE_MEDICATION,
            self::VALUE_WATER_MULTI_FUNCTION,
            self::VALUE_WATER_FLOOD,
            self::VALUE_CAR_MONITOR,
            self::VALUE_OUTPUT_EXPANDER,
            self::VALUE_POWER_SUPPLY,
            self::VALUE_HIGH_CURRENT_OUTPUT,
            self::VALUE_IQSHOCK,
            self::VALUE_IQDOOR_BELL,
            self::VALUE_CONTACT_MULTI_FUNCTION,
            self::VALUE_IQSMOKE_MULTI_FUNCTION,
            self::VALUE_SHOCK_OTHERS,
            self::VALUE_RFTRANSCEIVER,
            self::VALUE_AUDIO_MODULE,
            self::VALUE_GAS,
            self::VALUE_REMOTE_SWITCH_ACCESSORY,
            self::VALUE_AUXILIARY_SENSOR,
            self::VALUE_SECURED_DEVICE,
            self::VALUE_IRRIGATION_ZONE,
            self::VALUE_WATER_METER,
            self::VALUE_PROPANE_MONITOR,
            self::VALUE_TROUBLE_SENSOR,
            self::VALUE_CLIMAX_PIRCAMERA,
            self::VALUE_DSCPIRCAMERA,
            self::VALUE_QOLSYS_PANEL_CAMERA,
            self::VALUE_BLUETOOTH_DEVICE,
            self::VALUE_IRRIGATION_CONTROLLER,
            self::VALUE_REMOTE,
            self::VALUE_MERCURY_SCP,
            self::VALUE_ACCESS_CARD_READER,
            self::VALUE_OIL_GAUGE,
            self::VALUE_BUS_ZONE_EXPANDER,
            self::VALUE_SIO_PANEL,
            self::VALUE_VALVE_SWITCH,
            self::VALUE_AUDIO_CONTROLLER,
            self::VALUE_AUDIO_ZONE,
            self::VALUE_IQTAKEOVER_MODULE,
            self::VALUE_IQTRANSLATOR,
            self::VALUE_WI_FI_ACCESS_POINT,
            self::VALUE_IQPANEL_GLASSBREAK,
            self::VALUE_WIFI_TABLET,
            self::VALUE_HIGH_CURRENT_POWER_SUPPLY,
            self::VALUE_IOEXPANDER_MODULE,
            self::VALUE_CORBUS_REPEATER,
            self::VALUE_IQPANEL_BLUETOOTH_SPEAKER,
            self::VALUE_IQPANEL_MOTION_DETECTOR,
            self::VALUE_CONTROLLER,
            self::VALUE_HONEYWELL_PANEL_CAMERA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
