<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBusinessActivityAnalyticsMetricInfoOutput StructType
 * @subpackage Structs
 */
class GetBusinessActivityAnalyticsMetricInfoOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The MetricInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\BusinessActivityAnalyticsMetricInfo
     */
    public $MetricInfo;
    /**
     * Constructor method for GetBusinessActivityAnalyticsMetricInfoOutput
     * @uses GetBusinessActivityAnalyticsMetricInfoOutput::setSuccess()
     * @uses GetBusinessActivityAnalyticsMetricInfoOutput::setErrorMessage()
     * @uses GetBusinessActivityAnalyticsMetricInfoOutput::setMetricInfo()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\StructType\BusinessActivityAnalyticsMetricInfo $metricInfo
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\StructType\BusinessActivityAnalyticsMetricInfo $metricInfo = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setMetricInfo($metricInfo);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetBusinessActivityAnalyticsMetricInfoOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetBusinessActivityAnalyticsMetricInfoOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get MetricInfo value
     * @return \CustomerManagement\StructType\BusinessActivityAnalyticsMetricInfo|null
     */
    public function getMetricInfo()
    {
        return $this->MetricInfo;
    }
    /**
     * Set MetricInfo value
     * @param \CustomerManagement\StructType\BusinessActivityAnalyticsMetricInfo $metricInfo
     * @return \CustomerManagement\StructType\GetBusinessActivityAnalyticsMetricInfoOutput
     */
    public function setMetricInfo(\CustomerManagement\StructType\BusinessActivityAnalyticsMetricInfo $metricInfo = null)
    {
        $this->MetricInfo = $metricInfo;
        return $this;
    }
}
