<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignalStrengthInfo StructType
 * @subpackage Structs
 */
class SignalStrengthInfo extends AbstractStructBase
{
    /**
     * The ReportedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReportedDate;
    /**
     * The GsmRegistrationState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GsmRegistrationState;
    /**
     * The GsmBarSignalLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GsmBarSignalLevel;
    /**
     * The GsmBandSelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GsmBandSelection;
    /**
     * The GsmTowerFrequency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GsmTowerFrequency;
    /**
     * The TimeToRegisterSeconds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TimeToRegisterSeconds;
    /**
     * The RegistrationAttempts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RegistrationAttempts;
    /**
     * Constructor method for SignalStrengthInfo
     * @uses SignalStrengthInfo::setReportedDate()
     * @uses SignalStrengthInfo::setGsmRegistrationState()
     * @uses SignalStrengthInfo::setGsmBarSignalLevel()
     * @uses SignalStrengthInfo::setGsmBandSelection()
     * @uses SignalStrengthInfo::setGsmTowerFrequency()
     * @uses SignalStrengthInfo::setTimeToRegisterSeconds()
     * @uses SignalStrengthInfo::setRegistrationAttempts()
     * @param string $reportedDate
     * @param string $gsmRegistrationState
     * @param string $gsmBarSignalLevel
     * @param string $gsmBandSelection
     * @param string $gsmTowerFrequency
     * @param int $timeToRegisterSeconds
     * @param int $registrationAttempts
     */
    public function __construct($reportedDate = null, $gsmRegistrationState = null, $gsmBarSignalLevel = null, $gsmBandSelection = null, $gsmTowerFrequency = null, $timeToRegisterSeconds = null, $registrationAttempts = null)
    {
        $this
            ->setReportedDate($reportedDate)
            ->setGsmRegistrationState($gsmRegistrationState)
            ->setGsmBarSignalLevel($gsmBarSignalLevel)
            ->setGsmBandSelection($gsmBandSelection)
            ->setGsmTowerFrequency($gsmTowerFrequency)
            ->setTimeToRegisterSeconds($timeToRegisterSeconds)
            ->setRegistrationAttempts($registrationAttempts);
    }
    /**
     * Get ReportedDate value
     * @return string
     */
    public function getReportedDate()
    {
        return $this->ReportedDate;
    }
    /**
     * Set ReportedDate value
     * @param string $reportedDate
     * @return \CustomerManagement\StructType\SignalStrengthInfo
     */
    public function setReportedDate($reportedDate = null)
    {
        // validation for constraint: string
        if (!is_null($reportedDate) && !is_string($reportedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportedDate, true), gettype($reportedDate)), __LINE__);
        }
        $this->ReportedDate = $reportedDate;
        return $this;
    }
    /**
     * Get GsmRegistrationState value
     * @return string
     */
    public function getGsmRegistrationState()
    {
        return $this->GsmRegistrationState;
    }
    /**
     * Set GsmRegistrationState value
     * @uses \CustomerManagement\EnumType\GsmRegistrationStateEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\GsmRegistrationStateEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gsmRegistrationState
     * @return \CustomerManagement\StructType\SignalStrengthInfo
     */
    public function setGsmRegistrationState($gsmRegistrationState = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\GsmRegistrationStateEnum::valueIsValid($gsmRegistrationState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\GsmRegistrationStateEnum', is_array($gsmRegistrationState) ? implode(', ', $gsmRegistrationState) : var_export($gsmRegistrationState, true), implode(', ', \CustomerManagement\EnumType\GsmRegistrationStateEnum::getValidValues())), __LINE__);
        }
        $this->GsmRegistrationState = $gsmRegistrationState;
        return $this;
    }
    /**
     * Get GsmBarSignalLevel value
     * @return string
     */
    public function getGsmBarSignalLevel()
    {
        return $this->GsmBarSignalLevel;
    }
    /**
     * Set GsmBarSignalLevel value
     * @uses \CustomerManagement\EnumType\GsmBarSignalLevelEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\GsmBarSignalLevelEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gsmBarSignalLevel
     * @return \CustomerManagement\StructType\SignalStrengthInfo
     */
    public function setGsmBarSignalLevel($gsmBarSignalLevel = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\GsmBarSignalLevelEnum::valueIsValid($gsmBarSignalLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\GsmBarSignalLevelEnum', is_array($gsmBarSignalLevel) ? implode(', ', $gsmBarSignalLevel) : var_export($gsmBarSignalLevel, true), implode(', ', \CustomerManagement\EnumType\GsmBarSignalLevelEnum::getValidValues())), __LINE__);
        }
        $this->GsmBarSignalLevel = $gsmBarSignalLevel;
        return $this;
    }
    /**
     * Get GsmBandSelection value
     * @return string
     */
    public function getGsmBandSelection()
    {
        return $this->GsmBandSelection;
    }
    /**
     * Set GsmBandSelection value
     * @uses \CustomerManagement\EnumType\GsmBandSelectionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\GsmBandSelectionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gsmBandSelection
     * @return \CustomerManagement\StructType\SignalStrengthInfo
     */
    public function setGsmBandSelection($gsmBandSelection = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\GsmBandSelectionEnum::valueIsValid($gsmBandSelection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\GsmBandSelectionEnum', is_array($gsmBandSelection) ? implode(', ', $gsmBandSelection) : var_export($gsmBandSelection, true), implode(', ', \CustomerManagement\EnumType\GsmBandSelectionEnum::getValidValues())), __LINE__);
        }
        $this->GsmBandSelection = $gsmBandSelection;
        return $this;
    }
    /**
     * Get GsmTowerFrequency value
     * @return string
     */
    public function getGsmTowerFrequency()
    {
        return $this->GsmTowerFrequency;
    }
    /**
     * Set GsmTowerFrequency value
     * @uses \CustomerManagement\EnumType\GsmTowerFrequencyEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\GsmTowerFrequencyEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gsmTowerFrequency
     * @return \CustomerManagement\StructType\SignalStrengthInfo
     */
    public function setGsmTowerFrequency($gsmTowerFrequency = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\GsmTowerFrequencyEnum::valueIsValid($gsmTowerFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\GsmTowerFrequencyEnum', is_array($gsmTowerFrequency) ? implode(', ', $gsmTowerFrequency) : var_export($gsmTowerFrequency, true), implode(', ', \CustomerManagement\EnumType\GsmTowerFrequencyEnum::getValidValues())), __LINE__);
        }
        $this->GsmTowerFrequency = $gsmTowerFrequency;
        return $this;
    }
    /**
     * Get TimeToRegisterSeconds value
     * @return int
     */
    public function getTimeToRegisterSeconds()
    {
        return $this->TimeToRegisterSeconds;
    }
    /**
     * Set TimeToRegisterSeconds value
     * @param int $timeToRegisterSeconds
     * @return \CustomerManagement\StructType\SignalStrengthInfo
     */
    public function setTimeToRegisterSeconds($timeToRegisterSeconds = null)
    {
        // validation for constraint: int
        if (!is_null($timeToRegisterSeconds) && !(is_int($timeToRegisterSeconds) || ctype_digit($timeToRegisterSeconds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeToRegisterSeconds, true), gettype($timeToRegisterSeconds)), __LINE__);
        }
        $this->TimeToRegisterSeconds = $timeToRegisterSeconds;
        return $this;
    }
    /**
     * Get RegistrationAttempts value
     * @return int
     */
    public function getRegistrationAttempts()
    {
        return $this->RegistrationAttempts;
    }
    /**
     * Set RegistrationAttempts value
     * @param int $registrationAttempts
     * @return \CustomerManagement\StructType\SignalStrengthInfo
     */
    public function setRegistrationAttempts($registrationAttempts = null)
    {
        // validation for constraint: int
        if (!is_null($registrationAttempts) && !(is_int($registrationAttempts) || ctype_digit($registrationAttempts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($registrationAttempts, true), gettype($registrationAttempts)), __LINE__);
        }
        $this->RegistrationAttempts = $registrationAttempts;
        return $this;
    }
}
