<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemCheckCategoryOutput StructType
 * @subpackage Structs
 */
class SystemCheckCategoryOutput extends AbstractStructBase
{
    /**
     * The TestCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TestCategory;
    /**
     * The IsRunning
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRunning;
    /**
     * The CategoryResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CategoryResult;
    /**
     * The TestCategoryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TestCategoryName;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The TroubleShootingSteps
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TroubleShootingSteps;
    /**
     * Constructor method for SystemCheckCategoryOutput
     * @uses SystemCheckCategoryOutput::setTestCategory()
     * @uses SystemCheckCategoryOutput::setIsRunning()
     * @uses SystemCheckCategoryOutput::setCategoryResult()
     * @uses SystemCheckCategoryOutput::setTestCategoryName()
     * @uses SystemCheckCategoryOutput::setMessage()
     * @uses SystemCheckCategoryOutput::setTroubleShootingSteps()
     * @param string $testCategory
     * @param bool $isRunning
     * @param string $categoryResult
     * @param string $testCategoryName
     * @param string $message
     * @param string $troubleShootingSteps
     */
    public function __construct($testCategory = null, $isRunning = null, $categoryResult = null, $testCategoryName = null, $message = null, $troubleShootingSteps = null)
    {
        $this
            ->setTestCategory($testCategory)
            ->setIsRunning($isRunning)
            ->setCategoryResult($categoryResult)
            ->setTestCategoryName($testCategoryName)
            ->setMessage($message)
            ->setTroubleShootingSteps($troubleShootingSteps);
    }
    /**
     * Get TestCategory value
     * @return string
     */
    public function getTestCategory()
    {
        return $this->TestCategory;
    }
    /**
     * Set TestCategory value
     * @uses \CustomerManagement\EnumType\SystemCheckTestCategoryEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\SystemCheckTestCategoryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $testCategory
     * @return \CustomerManagement\StructType\SystemCheckCategoryOutput
     */
    public function setTestCategory($testCategory = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\SystemCheckTestCategoryEnum::valueIsValid($testCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\SystemCheckTestCategoryEnum', is_array($testCategory) ? implode(', ', $testCategory) : var_export($testCategory, true), implode(', ', \CustomerManagement\EnumType\SystemCheckTestCategoryEnum::getValidValues())), __LINE__);
        }
        $this->TestCategory = $testCategory;
        return $this;
    }
    /**
     * Get IsRunning value
     * @return bool
     */
    public function getIsRunning()
    {
        return $this->IsRunning;
    }
    /**
     * Set IsRunning value
     * @param bool $isRunning
     * @return \CustomerManagement\StructType\SystemCheckCategoryOutput
     */
    public function setIsRunning($isRunning = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRunning) && !is_bool($isRunning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRunning, true), gettype($isRunning)), __LINE__);
        }
        $this->IsRunning = $isRunning;
        return $this;
    }
    /**
     * Get CategoryResult value
     * @return string
     */
    public function getCategoryResult()
    {
        return $this->CategoryResult;
    }
    /**
     * Set CategoryResult value
     * @uses \CustomerManagement\EnumType\SystemCheckTestResultEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\SystemCheckTestResultEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $categoryResult
     * @return \CustomerManagement\StructType\SystemCheckCategoryOutput
     */
    public function setCategoryResult($categoryResult = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\SystemCheckTestResultEnum::valueIsValid($categoryResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\SystemCheckTestResultEnum', is_array($categoryResult) ? implode(', ', $categoryResult) : var_export($categoryResult, true), implode(', ', \CustomerManagement\EnumType\SystemCheckTestResultEnum::getValidValues())), __LINE__);
        }
        $this->CategoryResult = $categoryResult;
        return $this;
    }
    /**
     * Get TestCategoryName value
     * @return string|null
     */
    public function getTestCategoryName()
    {
        return $this->TestCategoryName;
    }
    /**
     * Set TestCategoryName value
     * @param string $testCategoryName
     * @return \CustomerManagement\StructType\SystemCheckCategoryOutput
     */
    public function setTestCategoryName($testCategoryName = null)
    {
        // validation for constraint: string
        if (!is_null($testCategoryName) && !is_string($testCategoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($testCategoryName, true), gettype($testCategoryName)), __LINE__);
        }
        $this->TestCategoryName = $testCategoryName;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \CustomerManagement\StructType\SystemCheckCategoryOutput
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get TroubleShootingSteps value
     * @return string|null
     */
    public function getTroubleShootingSteps()
    {
        return $this->TroubleShootingSteps;
    }
    /**
     * Set TroubleShootingSteps value
     * @param string $troubleShootingSteps
     * @return \CustomerManagement\StructType\SystemCheckCategoryOutput
     */
    public function setTroubleShootingSteps($troubleShootingSteps = null)
    {
        // validation for constraint: string
        if (!is_null($troubleShootingSteps) && !is_string($troubleShootingSteps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($troubleShootingSteps, true), gettype($troubleShootingSteps)), __LINE__);
        }
        $this->TroubleShootingSteps = $troubleShootingSteps;
        return $this;
    }
}
